/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class Player
extends Sprite {
    private int score = 0;
    private ImageIcon[] running_sequence;
    private ImageIcon standing_image;
    private ImageIcon kicking_image;
    private ImageIcon[] intercepting_sequence;
    private ImageIcon fall_back;
    private ImageIcon fall_front;
    private String team_name;
    private int current_status;
    private int running_frame;
    private AudioClip fight_song;
    public static final int STANDING = 0;
    public static final int RUNNING = 1;
    public static final int DUCK_FLYING = 2;
    public static final int DUCK_LANDED = 3;
    public static final int TOUCHDOWN = 4;
    public static final int SPRING_FORWARD = 5;
    public static final int FALL_BACK = 6;
    public static final int RUNNING_IN_PLACE = 7;
    public static final int BEFORE_INTERCEPTION = 8;
    public static final int AFTER_INTERCEPTION = 9;

    public Player(int n, String string) {
        this.team_name = string;
        this.current_status = 0;
        this.running_frame = 0;
        this.running_sequence = new ImageIcon[4];
        this.intercepting_sequence = new ImageIcon[4];
        this.standing_image = new ImageIcon("data/images/standing" + String.valueOf(n) + ".gif");
        int n2 = 0;
        while (n2 < 4) {
            this.running_sequence[n2] = new ImageIcon("data/images/running" + String.valueOf(n) + "_" + String.valueOf(n2) + ".gif");
            this.intercepting_sequence[n2] = new ImageIcon("data/images/interception" + String.valueOf(n) + "_" + String.valueOf(n2) + ".gif");
            ++n2;
        }
        this.kicking_image = new ImageIcon("data/images/kicking" + String.valueOf(n) + ".gif");
        this.fall_front = new ImageIcon("data/images/fall_front" + String.valueOf(n) + ".gif");
        this.fall_back = new ImageIcon("data/images/fall_back" + String.valueOf(n) + ".gif");
        this.current_image = this.standing_image;
        try {
            URL uRL = new URL("file:" + System.getProperty("user.dir") + "/data/audio/fight_song" + String.valueOf(n) + ".wav");
            this.fight_song = Applet.newAudioClip(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException.getMessage());
        }
    }

    public void setDefaults(int n, int n2) {
        this.score = 0;
        this.returnToHomePosition(n, n2);
    }

    public void returnToHomePosition(int n, int n2) {
        this.frameMod = 0;
        this.current_status = n == 0 ? 7 : 0;
        this.current_image = this.standing_image;
        this.running_frame = 0;
        this.x = (int)((double)n2 / 2.0);
        this.y = -3;
    }

    public void prepareToIntercept(int n) {
        this.frameMod = 0;
        this.running_frame = 0;
        this.current_image = this.running_sequence[this.running_frame];
        this.x = n;
        this.y = -3;
    }

    public void advanceFrame(boolean bl) {
        if (this.frameMod++ % 3 == 0) {
            this.current_image = this.running_sequence[this.running_frame % 4];
            ++this.running_frame;
        }
        if (bl) {
            this.x -= 25;
        }
    }

    public void advanceFrame_carryingDuck() {
        if (this.frameMod++ % 3 == 0) {
            this.current_image = this.intercepting_sequence[this.running_frame % 4];
            ++this.running_frame;
        }
        this.x -= 25;
    }

    public int getScore() {
        return this.score;
    }

    public void incrementScore(int n) {
        this.score += n;
    }

    public String getName() {
        return this.team_name;
    }

    public void setStatus(int n) {
        this.current_status = n;
    }

    public int getStatus() {
        return this.current_status;
    }

    public void kick() {
        this.current_image = this.kicking_image;
    }

    public void spring_forward() {
        this.current_status = 5;
        this.current_image = this.fall_front;
        this.x += 100;
        this.y = -10;
    }

    public void fall_back() {
        this.current_status = 6;
        this.current_image = this.fall_back;
        this.y = -10;
    }

    public void fadeAway(int n) {
        this.x -= n;
    }

    public void playSong() {
        if (SoundEffects.enabled()) {
            this.fight_song.loop();
        }
    }

    public void stopSong() {
        this.fight_song.stop();
    }
}

