/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import javax.naming.CommunicationException;
import javax.naming.NamingException;

class Header {
    static final int HEADER_SIZE = 12;
    static final short QR_BIT = Short.MIN_VALUE;
    static final short OPCODE_MASK = 30720;
    static final int OPCODE_SHIFT = 11;
    static final short AA_BIT = 1024;
    static final short TC_BIT = 512;
    static final short RD_BIT = 256;
    static final short RA_BIT = 128;
    static final short RCODE_MASK = 15;
    int xid;
    boolean query;
    int opcode;
    boolean authoritative;
    boolean truncated;
    boolean recursionDesired;
    boolean recursionAvail;
    int rcode;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;

    private static int getShort(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    Header(byte[] byArray, int n2) throws NamingException {
        this.decode(byArray, n2);
    }

    private void decode(byte[] byArray, int n2) throws NamingException {
        try {
            int n3 = 0;
            if (n2 < 12) {
                throw new CommunicationException("DNS error: corrupted message header");
            }
            this.xid = Header.getShort(byArray, n3);
            short s2 = (short)Header.getShort(byArray, n3 += 2);
            n3 += 2;
            this.query = (s2 & Short.MIN_VALUE) == 0;
            this.opcode = (s2 & 0x7800) >>> 11;
            this.authoritative = (s2 & 0x400) != 0;
            this.truncated = (s2 & 0x200) != 0;
            this.recursionDesired = (s2 & 0x100) != 0;
            this.recursionAvail = (s2 & 0x80) != 0;
            this.rcode = s2 & 0xF;
            this.numQuestions = Header.getShort(byArray, n3);
            this.numAnswers = Header.getShort(byArray, n3 += 2);
            this.numAuthorities = Header.getShort(byArray, n3 += 2);
            this.numAdditionals = Header.getShort(byArray, n3 += 2);
            n3 += 2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CommunicationException("DNS error: corrupted message header");
        }
    }
}

