/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    short[][] data;

    public final short[][] getTable() {
        return this.data;
    }

    public ShortLookupTable(int n2, short[] sArray) {
        super(n2, sArray.length);
        this.numComponents = 1;
        this.numEntries = sArray.length;
        this.data = new short[1][];
        this.data[0] = sArray;
    }

    public ShortLookupTable(int n2, short[][] sArray) {
        super(n2, sArray.length);
        this.numComponents = sArray.length;
        this.numEntries = sArray[0].length;
        this.data = new short[this.numComponents][];
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            this.data[i2] = sArray[i2];
        }
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = (nArray[i2] & 0xFFFF) - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i2 + "]-offset is " + "less than zero");
                }
                nArray2[i2] = this.data[0][n2];
            }
        } else {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n3 = (nArray[i3] & 0xFFFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i3 + "]-offset is " + "less than zero");
                }
                nArray2[i3] = this.data[i3][n3];
            }
        }
        return nArray2;
    }

    public short[] lookupPixel(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            sArray2 = new short[sArray.length];
        }
        if (this.numComponents == 1) {
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                int n2 = (sArray[i2] & 0xFFFF) - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i2 + "]-offset is " + "less than zero");
                }
                sArray2[i2] = this.data[0][n2];
            }
        } else {
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                int n3 = (sArray[i3] & 0xFFFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i3 + "]-offset is " + "less than zero");
                }
                sArray2[i3] = this.data[i3][n3];
            }
        }
        return sArray2;
    }
}

