/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xml.dtm.ref.DTMStringPool;

public class ExpandedNameTable {
    private Vector m_extendedTypes;
    private int m_nextType;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int CDATA_SECTION = 4;
    public static final int ENTITY_REFERENCE = 5;
    public static final int ENTITY = 6;
    public static final int PROCESSING_INSTRUCTION = 7;
    public static final int COMMENT = 8;
    public static final int DOCUMENT = 9;
    public static final int DOCUMENT_TYPE = 10;
    public static final int DOCUMENT_FRAGMENT = 11;
    public static final int NOTATION = 12;
    public static final int NAMESPACE = 13;
    Hashtable m_hashtable = new Hashtable();
    ExtendedType hashET = new ExtendedType(-1, "", "");
    private static Hashtable m_defaultHashtable;
    private static Vector m_defaultExtendedTypes;

    static {
        m_defaultExtendedTypes = new Vector(23);
        m_defaultHashtable = new Hashtable(23, 0.75f);
        for (int i2 = 0; i2 < 14; ++i2) {
            ExtendedType extendedType = new ExtendedType(i2, "", "");
            m_defaultExtendedTypes.addElement(extendedType);
            m_defaultHashtable.put(extendedType, new Integer(i2));
        }
    }

    public ExpandedNameTable() {
        this.initExtendedTypes();
    }

    private void initExtendedTypes() {
        this.m_extendedTypes = (Vector)m_defaultExtendedTypes.clone();
        this.m_hashtable = (Hashtable)m_defaultHashtable.clone();
        this.m_nextType = this.m_extendedTypes.size();
    }

    public int getExpandedTypeID(int n2) {
        return n2;
    }

    public final int getLocalNameID(int n2) {
        ExtendedType extendedType = (ExtendedType)this.m_extendedTypes.elementAt(n2);
        if (extendedType.localName.equals("")) {
            return 0;
        }
        return n2;
    }

    public final int getNamespaceID(int n2) {
        ExtendedType extendedType = (ExtendedType)this.m_extendedTypes.elementAt(n2);
        if (extendedType.namespace.equals("")) {
            return 0;
        }
        return n2;
    }

    public final short getType(int n2) {
        ExtendedType extendedType = (ExtendedType)this.m_extendedTypes.elementAt(n2);
        return (short)extendedType.nodetype;
    }

    public String getLocalName(int n2) {
        ExtendedType extendedType = (ExtendedType)this.m_extendedTypes.elementAt(n2);
        return extendedType.localName;
    }

    public String getNamespace(int n2) {
        ExtendedType extendedType = (ExtendedType)this.m_extendedTypes.elementAt(n2);
        return extendedType.namespace.equals("") ? null : extendedType.namespace;
    }

    public int getExpandedTypeID(String string, String string2, int n2) {
        if (null == string) {
            string = "";
        }
        if (null == string2) {
            string2 = "";
        }
        this.hashET.redefine(n2, string, string2);
        Object object = this.m_hashtable.get(this.hashET);
        if (object != null) {
            return (Integer)object;
        }
        ExtendedType extendedType = new ExtendedType(n2, string, string2);
        this.m_extendedTypes.addElement(extendedType);
        this.m_hashtable.put(extendedType, new Integer(this.m_nextType));
        return this.m_nextType++;
    }

    public ExpandedNameTable(DTMStringPool dTMStringPool, DTMStringPool dTMStringPool2) {
        this.initExtendedTypes();
    }

    private static class ExtendedType {
        protected int nodetype;
        protected String namespace;
        protected String localName;
        protected int hash;

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            try {
                ExtendedType extendedType = (ExtendedType)object;
                return extendedType.nodetype == this.nodetype && extendedType.localName.equals(this.localName) && extendedType.namespace.equals(this.namespace);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        protected ExtendedType(int n2, String string, String string2) {
            this.nodetype = n2;
            this.namespace = string;
            this.localName = string2;
            this.hash = n2 + string.hashCode() + string2.hashCode();
        }

        protected void redefine(int n2, String string, String string2) {
            this.nodetype = n2;
            this.namespace = string;
            this.localName = string2;
            this.hash = n2 + string.hashCode() + string2.hashCode();
        }
    }
}

