/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.security.AccessController;
import sun.awt.DebugHelper;
import sun.awt.DisplayChangedListener;
import sun.awt.RepaintArea;
import sun.awt.Win32GraphicsConfig;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGlobalCursorManager;
import sun.awt.windows.WImage;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WVolatileImage;
import sun.awt.windows.Win32BackBuffer;
import sun.awt.windows.Win32OffScreenImage;
import sun.awt.windows.Win32SurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.security.action.GetPropertyAction;

public abstract class WComponentPeer
extends WObjectPeer
implements ComponentPeer,
DropTargetPeer,
DisplayChangedListener {
    private static final DebugHelper dbg = DebugHelper.create(WComponentPeer.class);
    private static boolean ddoffscreen;
    Win32SurfaceData surfaceData;
    private RepaintArea paintArea;
    protected Win32GraphicsConfig winGraphicsConfig;
    boolean isLayouting = false;
    boolean paintPending = false;
    int oldWidth = -1;
    int oldHeight = -1;
    private int numBackBuffers = 0;
    private Win32BackBuffer backBuffer = null;
    int nDropTargets;
    long nativeDropTargetContext;
    public int serialNum = 0;
    private static final double BANDING_DIVISOR = 4.0;
    static final Font defaultFont;
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;

    native long addNativeDropTarget();

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        if (string != null) {
            boolean bl2;
            ddoffscreen = string.equals("true") || string.equals("t");
            boolean bl3 = bl2 = string.equals("false") || string.equals("f");
            if (bl2) {
                ddoffscreen = false;
                System.out.println("Disabling offscreen DirectDraw acceleration");
            }
        }
        if (ddoffscreen) {
            System.out.println("Forcing offscreen DirectDraw acceleration");
        }
        WComponentPeer.wheelInit();
        defaultFont = new Font("Dialog", 0, 12);
    }

    private synchronized native void _dispose();

    private void assertFullScreen() throws AWTException {
        if (!this.isFullScreen()) {
            throw new AWTException("The operation requested is only supported on a full-screen exclusive window");
        }
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public native void beginValidate();

    private synchronized void createBackBuffer() {
        this.backBuffer = this.numBackBuffers > 0 ? new Win32BackBuffer((Component)this.target, this.surfaceData) : null;
    }

    public synchronized void destroyBuffers() {
        this.disposeBackBuffer();
        this.numBackBuffers = 0;
    }

    public synchronized native void disable();

    public void displayChanged() {
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            // empty catch block
        }
    }

    private synchronized void disposeBackBuffer() {
        if (this.backBuffer == null) {
            return;
        }
        this.backBuffer = null;
    }

    protected void disposeImpl() {
        Win32SurfaceData win32SurfaceData = this.surfaceData;
        this.surfaceData = null;
        win32SurfaceData.invalidate();
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    void dynamicallyLayoutContainer() {
        final Container container = (Container)this.target;
        WToolkit.executeOnEventHandlerThread(container, new Runnable(){

            public void run() {
                container.invalidate();
                container.validate();
            }
        });
    }

    public synchronized native void enable();

    public void endLayout() {
        if (!(this.paintArea.isEmpty() || this.paintPending || ((Component)this.target).getIgnoreRepaint())) {
            this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public native void endValidate();

    public synchronized native void hide();

    public void initZOrderPosition() {
        Container container = ((Component)this.target).getParent();
        WComponentPeer wComponentPeer = null;
        if (container != null) {
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < componentArray.length && componentArray[i2] != this.target; ++i2) {
                Object object = WToolkit.targetToPeer(componentArray[i2]);
                if (object == null || object instanceof LightweightPeer) continue;
                wComponentPeer = (WComponentPeer)object;
            }
        }
        this.setZOrderPosition(wComponentPeer);
    }

    void initialize() {
        Font font;
        Color color;
        this.initZOrderPosition();
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((color = ((Component)this.target).getForeground()) != null) {
            this.setForeground(color);
        }
        if ((font = ((Component)this.target).getFont()) != null) {
            this.setFont(font);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = ((Component)this.target).getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public synchronized native void pShow();

    void paintDamagedAreaImmediately() {
        this.updateWindow();
        WToolkit.getWToolkit();
        WToolkit.flushPendingEvents();
        this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
    }

    public void paletteChanged() {
    }

    native void removeNativeDropTarget();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSurfaceData() {
        Object object = ((Component)this.target).getTreeLock();
        synchronized (object) {
            WComponentPeer wComponentPeer = this;
            synchronized (wComponentPeer) {
                if (this.pData == 0L) {
                    return;
                }
                Win32SurfaceData win32SurfaceData = this.surfaceData;
                this.surfaceData = Win32SurfaceData.createData(this, this.numBackBuffers);
                if (win32SurfaceData != null) {
                    win32SurfaceData.invalidate();
                }
                this.createBackBuffer();
            }
        }
    }

    public void replaceSurfaceDataLater() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    WComponentPeer.this.replaceSurfaceData();
                }
                catch (InvalidPipeException invalidPipeException) {
                    // empty catch block
                }
            }
        });
    }

    public void show() {
        Dimension dimension = ((Component)this.target).getSize();
        this.oldHeight = dimension.height;
        this.oldWidth = dimension.width;
        this.pShow();
    }

    synchronized native void start();

    public final void updateCursorImmediately() {
        WGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    synchronized native void updateWindow();

    static native void wheelInit();

    public boolean canDetermineObscurity() {
        return true;
    }

    public boolean handlesWheelScrolling() {
        return this.nativeHandlesWheelScrolling();
    }

    public boolean isFocusable() {
        return false;
    }

    private boolean isFullScreen() {
        Component component;
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        for (component = (Component)this.target; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        return component == graphicsDevice.getFullScreenWindow();
    }

    public native boolean isObscured();

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    native boolean nativeHandlesWheelScrolling();

    public boolean shouldClearRectBeforePaint() {
        return true;
    }

    public native void _setBackground(int var1);

    public native void _setForeground(int var1);

    void handleExpose(int n2, int n3, int n4, int n5) {
        if (!((Component)this.target).getIgnoreRepaint()) {
            this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n2, n3, n4, n5)));
        }
    }

    void handlePaint(int n2, int n3, int n4, int n5) {
        if (!((Component)this.target).getIgnoreRepaint()) {
            this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n2, n3, n4, n5)));
        }
    }

    void handleRepaint(int n2, int n3, int n4, int n5) {
    }

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.paintPending = n4 != this.oldWidth || n5 != this.oldHeight;
        this.reshape(n2, n3, n4, n5);
        if (n4 != this.oldWidth || n5 != this.oldHeight) {
            try {
                this.replaceSurfaceData();
            }
            catch (InvalidPipeException invalidPipeException) {
                // empty catch block
            }
            this.oldWidth = n4;
            this.oldHeight = n5;
        }
        ++this.serialNum;
    }

    private native int[] createPrintedPixels(int var1, int var2, int var3, int var4);

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    public void setEnabled(boolean bl2) {
        if (bl2) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setVisible(boolean bl2) {
        if (bl2) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
                }
                return;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    native void nativeHandleEvent(AWTEvent var1);

    void postEvent(AWTEvent aWTEvent) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public synchronized void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        this.assertFullScreen();
        this.numBackBuffers = n2 - 1;
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            throw new AWTException(invalidPipeException.getMessage());
        }
    }

    public synchronized void flip(BufferCapabilities.FlipContents flipContents) {
        if (this.backBuffer == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        Component component = (Component)this.target;
        int n2 = component.getWidth();
        int n3 = component.getHeight();
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = component.getGraphics();
            graphics.drawImage(this.backBuffer, 0, 0, n2, n3, component);
            graphics.dispose();
        } else {
            try {
                this.surfaceData.flip(this.backBuffer.getHWSurfaceData());
            }
            catch (InvalidPipeException invalidPipeException) {
                return;
            }
            if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
                Graphics graphics = this.backBuffer.getGraphics();
                graphics.setColor(component.getBackground());
                graphics.fillRect(0, 0, n2, n3);
                graphics.dispose();
            }
        }
    }

    public synchronized void setBackground(Color color) {
        this._setBackground(color.getRGB());
    }

    public synchronized void setForeground(Color color) {
        this._setForeground(color.getRGB());
    }

    WComponentPeer(Component component) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = WToolkit.getNativeContainer(component);
        WComponentPeer wComponentPeer = (WComponentPeer)WToolkit.targetToPeer(container);
        this.create(wComponentPeer);
        this.surfaceData = Win32SurfaceData.createData(this, this.numBackBuffers);
        this.initialize();
        this.start();
    }

    public native boolean _requestFocus(Component var1, boolean var2, boolean var3, long var4);

    public boolean requestFocus(Component component, boolean bl2, boolean bl3, long l2) {
        if (WComponentPeer.processSynchronousLightweightTransfer((Component)this.target, component, bl2, bl3, l2)) {
            return true;
        }
        return this._requestFocus(component, bl2, bl3, l2);
    }

    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized native void setFont(Font var1);

    public synchronized Graphics getGraphics() {
        if (!this.isDisposed()) {
            Font font;
            Color color;
            Component component = (Component)this.target;
            Color color2 = component.getBackground();
            if (color2 == null) {
                color2 = SystemColor.window;
            }
            if ((color = component.getForeground()) == null) {
                color = SystemColor.windowText;
            }
            if ((font = component.getFont()) == null) {
                font = defaultFont;
            }
            return new SunGraphics2D(this.surfaceData, color, color2, font);
        }
        return null;
    }

    public void paint(Graphics graphics) {
        ((Component)this.target).paint(graphics);
    }

    public void print(Graphics graphics) {
        Component component = (Component)this.target;
        int n2 = component.getWidth();
        int n3 = component.getHeight();
        int n4 = (int)((double)n3 / 4.0);
        for (int i2 = 0; i2 < n3; i2 += n4) {
            int n5;
            int[] nArray;
            int n6 = i2 + n4 - 1;
            if (n6 >= n3) {
                n6 = n3 - 1;
            }
            if ((nArray = this.createPrintedPixels(0, i2, n2, n5 = n6 - i2 + 1)) == null) continue;
            BufferedImage bufferedImage = new BufferedImage(n2, n5, 1);
            bufferedImage.setRGB(0, 0, n2, n5, nArray, 0, n2);
            graphics.drawImage(bufferedImage, 0, i2, null);
            bufferedImage.flush();
        }
        component.print(graphics);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.winGraphicsConfig != null) {
            return this.winGraphicsConfig;
        }
        return ((Component)this.target).getGraphicsConfiguration();
    }

    public Image getBackBuffer() {
        if (this.backBuffer == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.backBuffer;
    }

    public Image createImage(int n2, int n3) {
        if (ddoffscreen) {
            return this.createVolatileImage(n2, n3);
        }
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        return new Win32OffScreenImage((Component)this.target, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    public native Point getLocationOnScreen();

    public Rectangle getBounds() {
        return ((Component)this.target).getBounds();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public synchronized void addDropTarget(DropTarget dropTarget) {
        if (this.nDropTargets == 0) {
            this.nativeDropTargetContext = this.addNativeDropTarget();
        }
        ++this.nDropTargets;
    }

    public synchronized void removeDropTarget(DropTarget dropTarget) {
        --this.nDropTargets;
        if (this.nDropTargets == 0) {
            this.removeNativeDropTarget();
            this.nativeDropTargetContext = 0L;
        }
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return null;
    }

    public ColorModel getDeviceColorModel() {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig.getDeviceColorModel();
        }
        return null;
    }

    public ColorModel getColorModel(int n2) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel(n2);
        }
        return null;
    }

    public VolatileImage createVolatileImage(int n2, int n3) {
        return new WVolatileImage((Component)this.target, n2, n3);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    abstract void create(WComponentPeer var1);

    native void setZOrderPosition(WComponentPeer var1);

    public Win32SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    static native boolean processSynchronousLightweightTransfer(Component var0, Component var1, boolean var2, boolean var3, long var4);

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n2, n3, imageObserver);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n2, n3, imageObserver);
    }
}

