/******************************************
DUCK PUNT
Copyright (C) 2005 Geoffrey M. Draper

This file is part of Duck Punt.
Duck Punt is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************/

import java.lang.String;
import java.lang.Math;
import java.awt.event.KeyEvent;

public class MathProblem
{
	private String problem;
	private int answer;
	private String charTyped1, charTyped2;
	private int relative_answer;
	
	public MathProblem()
	{
		makeNewProblem();
	}
	
	public String getProblemText()
	{
		return problem;
	}
	
	public String getCompleteSolution()
	{
		return problem + String.valueOf(answer);
	}
	
	public int getAnswer()
	{
		return answer;
	}
	
	public void makeNewProblem()
	{
		String operand = "+";
		int num1 = 1 + (int)(Math.random() * (double)15);
		int num2 = (int)(Math.random() * (double)15);
		answer = num1+num2;
		
		charTyped1 = "?";
		if (getNumDigits() == 2) charTyped2 = "?";
		else charTyped2 = " ";
		
		problem = String.valueOf(num1) + " " + operand + " " + String.valueOf(num2) + " = ";
	}
	
	public String getUserResponseText()
	{
		String str = charTyped1 + charTyped2;
		return str;	
	}
	
	public boolean handleKeyStrokes(KeyEvent e)
	{
		boolean done = false;
		char c = e.getKeyChar();
		
		//verify that the key typed is actually a numeric digit
		if (Character.isDigit(c))
		{
			if (charTyped1 == "?") {
				charTyped1 = (new Character(c)).toString();
				if (getNumDigits() == 1) done = true;
			}				
			else {
				charTyped2 = (new Character(c)).toString();
				done = true;
			}
		}
		
		//store the user's answer (high, correct, low) in "relative_answer" variable
		if (done) evaluateResponse();
		
		return done;
	}
	
	public int getNumDigits()
	{
		if (answer < 10) return 1;
		else return 2;
	}
	
	private void evaluateResponse()
	{
		/********************************************************
		* PRECONDITION: user's response must consist of only numeric characters
		* POSTCONDITION: function returns one of the following:
		*	<0 if the player's answer was too low
		*	 0 if the player's answer was correct
		*	>0 if the player's answer was too high
		********************************************************/
		String userResponse;
		int userAnswer=0;

		userResponse = charTyped1;
		if (getNumDigits() == 2) userResponse += charTyped2;
		
		try {
			userAnswer = Integer.parseInt(userResponse);
		} catch (NumberFormatException e) {System.out.println("invalid user input");}
		
		relative_answer = userAnswer - answer;
	}
	
	public int getRelativeAnswer()
	{
		return relative_answer;
	}

}
