/******************************************
DUCK PUNT
Copyright (C) 2005 Geoffrey M. Draper

This file is part of Duck Punt.
Duck Punt is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************/

import javax.swing.*;
import java.awt.*;

public class Sprite
{
	protected int x, y;
	protected ImageIcon current_image;
	protected int frameMod;

	public void setPosition(int X, int Y)
	{
		x=X; y=Y;
	}

	public void setY(int Y)
	{
		y=Y;
	}

	public void setX(int X)
	{
		x=X;
	}

	public void drawMe(DuckPunt c, Graphics g)
	{
		if (c.current_player == 0) {
			current_image.paintIcon(c, g, x-current_image.getIconWidth()/2, c.window_height-c.grass_depth-getHeight()-y);
		} else {
			current_image.paintIcon(c, g, c.window_width-x-current_image.getIconWidth()/2, c.window_height-c.grass_depth-getHeight()-y);
		}
	}

	public int getHeight()
	{
		return current_image.getIconHeight();
	}

	public int getWidth()
	{
		return current_image.getIconWidth();
	}

	public int getX()
	{
		return x;
	}

	public int getY()
	{
		return y;
	}

}
