#ifndef WIN32
/******************************************

GetProcByName - copyright 2003 John Dawson

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

******************************************/
#ifndef _PROCSTUFF_H_
#define _PROCSTUFF_H_

struct PROC_S {
	long pid;		/* process id */
	char cmd[40];	/* basename of executable file in call to exec(2) */
	char state;		/* single-char code for process state (S=sleeping) */
	long ppid;		/* pid of parent process */
	long pgrp;		/* process group id */
	int session;	/* session id */
	int ttydev;		/* full device number of controlling terminal */
	int tpgid;		/* terminal process group id */
	unsigned long flags;		/* kernel flags for the process */
	unsigned long minflt;	/* number of minor page faults since process start */
	unsigned long cminflt;	/* cumulative min_flt of process and child procs */
	unsigned long majflt;	/* number of major page faults since process start */
	unsigned long cmajflt;	/* cumulative maj_flt of process and child procs */
	unsigned long utime;		/* user-mode CPU time accumulated by process */
	unsigned long stime;		/* kernel-mode CPU time accumulated by process */
	unsigned long cutime;	/* cumulative utime of process and reaped children */
	unsigned long cstime;	/* cumulative stime of process and reaped children */
	int nice;		/* */
	int priority;	/* kernel scheduling priority */
	int counter;	/* current maximum size in jiffies */
	unsigned long timeout;		/* ? */
	unsigned long itrealvalue;	/* ? */
	unsigned long starttime;	/* start time of process: seconds since 1-1-70 */
	unsigned long vsize;			/* number of pages of virtual memory ... */
	unsigned long rss;			/* resident set size from /proc/#/stat */
	unsigned long rlim;			/* resident set size ... ? */
	unsigned long startcode;	/* address of beginning of code segment */
	unsigned long endcode;		/* address of end of code segment */
	unsigned long startstack;	/* address of the bottom of stack for process */
	unsigned long kstkesp;	/* kernel stack pointer */
	unsigned long kstkeip;	/* kernel stack pointer */
	long long signal;			/* mask of pending signals */
	long long blocked;		/* mask of blocked signals */
	long long sigignore;		/* mask of ignored signals */
	long long sigcatch;		/* mask of caught  signals */
	unsigned long wchan;	/* address of kernel wait channel proc is sleeping in */
	unsigned long filler1;
	unsigned long filler2;
};	/* End struct PROC_S */

/* Final, full-size proc structure for Linux. */
struct PROC
{	struct PROC_S sproc;
	int uid;
	int gid;
	char tty[25];
	char user[13];
	char cmdline[256];
};	/* End struct PROC */

#endif	/* _PROCSTUFF_H_ */
#endif //WIN32
