/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#include "application.h"
#include "splash.h"
#include "aboutbox.h"
#include "memento.h"
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qapplication.h>
#include <qnamespace.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <iostream.h>

extern GameData *gd;

ApplicationWindow::ApplicationWindow()
        : QMainWindow( 0, "main game window") {

	//display splash screen
	Splash *splash = new Splash();
	splash->show();

	QPixmap topleftIcon("data/images/icons/icon16x16.png");
	setIcon(topleftIcon);

	gb = new GameBoard(this, "gameboard");
	int windowWidth = 800;
	int windowHeight = 600;
	gb->setFocus();
	//by setting both 'gb' and 'this' to fixedsize, we stop the user from resizing the window
	gb->setFixedSize(windowWidth, windowHeight);
	setFixedSize(windowWidth, windowHeight);
	move(0,0);	//this puts the window in the top-left corner of the screen
	setCentralWidget( gb );

	//define menu bar
    QPopupMenu *fileMenu = new QPopupMenu( this );
    CHECK_PTR( fileMenu );
    //fileMenu->insertItem("New Game", this, SLOT(newGame()));
    //fileMenu->insertSeparator();
	//fileMenu->insertItem("Save Game", this, SLOT(saveGame()));
	//fileMenu->insertItem("Restore Game", this, SLOT(restoreGame()));
    fileMenu->insertSeparator();
	fileMenu->insertItem( "Quit", qApp, SLOT( quit() ) );
    optionsMenu = new QPopupMenu( this );
    CHECK_PTR( optionsMenu );
    //optionsMenu->insertItem("Speed", this, SLOT(speed()) );
    se = optionsMenu->insertItem("Sound Effects", this, SLOT(sound()) );
	optionsMenu->setItemChecked(se, gd->isSound);
    //int me = optionsMenu->insertItem("Music", this, SLOT(music()));
	//optionsMenu->setItemChecked(me, gd->isMusic);

    QPopupMenu *helpMenu = new QPopupMenu( this );
    CHECK_PTR( helpMenu );
    helpMenu->insertItem("Instructions", this, SLOT(help()) );
    helpMenu->insertItem("About Thirsty Nellan", this, SLOT(about()) );

	menuBar()->insertItem("File", fileMenu);
	menuBar()->insertItem("Options", optionsMenu);
	menuBar()->insertItem("Help", helpMenu);

	statusBar()->setSizeGripEnabled(FALSE);
	updateStatusBar();

	connect(gb, SIGNAL(roomChanged()), this, SLOT(updateStatusBar()));
	connect(gb, SIGNAL(scoreChanged()), this, SLOT(updateStatusBar()));
	connect(gb, SIGNAL(endgame()), qApp, SLOT(quit()));

	splash->callAccept();
}


ApplicationWindow::~ApplicationWindow() {
}

void ApplicationWindow::updateStatusBar() {
	QString msg = "You are in the " + gd->roomData[gd->currentRoom].roomName + "                             Score: " + QString::number(gd->score);
	statusBar()->message( msg );
}

void ApplicationWindow::newGame() {};

/*void ApplicationWindow::saveGame() {
	Memento* m = gd->createMemento();
	gb->setKeyboardFocus(false);
	QString filename = QFileDialog::getSaveFileName( QString::null, "*.sav", this, 0, "Save Game" );
	gb->setKeyboardFocus(true);
	if ( !filename.isEmpty() ) {
		// the user gave a file name
		QFile f(filename);
		if (f.open(IO_WriteOnly)) {
			QTextStream *ts = new QTextStream(&f);
			m->writeStateToFile(ts);
		}
		f.close();
	}
	delete m;
};

void ApplicationWindow::restoreGame() {
	Memento* m = gd->createEmptyMemento();
	gb->setKeyboardFocus(false);
	QString filename = QFileDialog::getOpenFileName( QString::null, "*.sav", this, 0, "Restore Game" );
	gb->setKeyboardFocus(true);
	if ( !filename.isEmpty() ) {
		// the user gave a file name
		QFile f(filename);
		if ( f.open(IO_ReadOnly) ) {    // file opened successfully
			QTextStream *ts = new QTextStream(&f);
			m->readStateFromFile(ts);
			gb->clearInventoryBox();
			gd->setMemento(m);
			gb->refreshAll();
		}
		f.close();
	}
	delete m;
}*/

void ApplicationWindow::sound() {
	gd->isSound = !(gd->isSound);
	optionsMenu->setItemChecked(se, gd->isSound);
};

void ApplicationWindow::music() {};

void ApplicationWindow::help() {
	QMessageBox::about( this, "Thirsty Nellan Instructions",
                            "You are in an enchanted house.\n"
							"Your goal is to collect four treasures and\n"
							"return them to the Banker.\n\n"
							"To pick up an object, click on it.\n"
							"To use an item in your inventory, click on it.\n"
							"To talk to someone, click on him or her.\n"
							"(What could be simpler?)");
};


void ApplicationWindow::about() {
	AboutBox *aboutBox = new AboutBox(this);
	aboutBox->show();

}

