/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <iostream.h>
#include <qpushbutton.h>
#include "infobox.h"
#include "gamedata.h"

extern GameData *gd;

InfoBox::InfoBox(QString filename, QString msg, QWidget *parent) :
				QDialog(parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_DialogBorder | Qt::WStyle_Title)
{
	QPixmap *image = new QPixmap(filename);
	gd->avatar->setVelocity(0,0);
	gd->dialogVisible = true;
	setCaption(gd->roomData[gd->currentRoom].roomName);
	QFont font("Helvetica", 12, QFont::Bold);
	QLabel *picture = new QLabel(this);
	picture->setPixmap(*image);
	QLabel *text = new QLabel(this);
	text->setBackgroundMode( PaletteBase );
	text->setFont(font);
	text->setText(msg);
	button = new QPushButton("OK", this);
	button->setFont(font);
	connect(button, SIGNAL(clicked()), this, SLOT(accept()));
	connect(button, SIGNAL(clicked()), this, SLOT(setDialogInvisible()));
	QGridLayout *l = new QGridLayout(this, 2, 2);
	l->addWidget(picture, 0, 0);
	l->addWidget(text, 0, 1, Qt::WordBreak);
	l->addMultiCellWidget(button, 1, 1, 0, 1, Qt::AlignCenter);
}

InfoBox::InfoBox(QString msg, QWidget *parent) :
				QDialog(parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_DialogBorder | Qt::WStyle_Title )
{
	QPixmap *image = new QPixmap("data/images/squares/information.png");
	gd->avatar->setVelocity(0,0);
	gd->dialogVisible = true;
	setCaption(gd->roomData[gd->currentRoom].roomName);
	QFont font("Helvetica", 12, QFont::Bold);
	QLabel *picture = new QLabel(this);
	picture->setPixmap(*image);
	QLabel *text = new QLabel(this);
	text->setBackgroundMode( PaletteBase );
	text->setFont(font);
	text->setText(msg);
	button = new QPushButton("OK", this);
	button->setFont(font);
	connect(button, SIGNAL(clicked()), this, SLOT(accept()));
	connect(button, SIGNAL(clicked()), this, SLOT(setDialogInvisible()));
	QGridLayout *l = new QGridLayout(this, 2, 2);
	l->addWidget(picture, 0, 0);
	l->addWidget(text, 0, 1, Qt::WordBreak);
	l->addMultiCellWidget(button, 1, 1, 0, 1, Qt::AlignCenter);
}

void InfoBox::keyPressEvent( QKeyEvent *e ) {
	int k = e->key();
	if (k == Qt::Key_Return || k == Qt::Key_Enter || k == Qt::Key_Space) {
		button->animateClick();
	}

}
void InfoBox::setDialogInvisible() {
	gd->dialogVisible = false;
}
