import java.applet.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.File;

class playSound {

	public static void main(String args[]) {
	
		if (args.length != 1) {
			System.err.println("Usage: java playSound <relative_path>");
			System.exit(1);
		}
	
		String filename = args[0];
		URL url;
		AudioClip ac;
		File f;
		long filesize = 45000;

		try {
			url = new URL("file:" + System.getProperty("user.dir") + "/" + filename);
			ac = Applet.newAudioClip(url);
			ac.play();
		} catch (MalformedURLException e) {
			System.err.println(e.getMessage());
		}

		try {
			f = new File(filename);
			filesize = f.length();
		} catch (NullPointerException e) {
			System.err.println(e.getMessage());
		}

		try {
			Thread.sleep((long)(filesize / 40.0));
		} catch (InterruptedException e) {
			System.err.println(e.getMessage());
		}

		System.exit(0);
	}
}
