/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibOid;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SnmpMibGroup
extends SnmpMibOid
implements Serializable {
    protected Hashtable subgroups = null;

    public abstract boolean isTable(long var1);

    public abstract boolean isVariable(long var1);

    public abstract boolean isReadable(long var1);

    public abstract SnmpMibTable getTable(long var1);

    public void validateVarId(long l, Object object) throws SnmpStatusException {
        if (!this.isVariable(l)) {
            throw noSuchObjectException;
        }
    }

    public boolean isNestedArc(long l) {
        if (this.subgroups == null) {
            return false;
        }
        Object v = this.subgroups.get(new Long(l));
        return v != null;
    }

    public abstract void get(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public abstract void set(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public abstract void check(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public void getRootOid(Vector vector) {
    }

    void registerNestedArc(long l) {
        Long l2 = new Long(l);
        if (this.subgroups == null) {
            this.subgroups = new Hashtable();
        }
        this.subgroups.put(l2, l2);
    }

    protected void registerObject(long l) throws IllegalAccessException {
        long[] lArray = new long[]{l};
        super.registerNode(lArray, 0, null);
    }

    void registerNode(long[] lArray, int n, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        super.registerNode(lArray, n, snmpMibNode);
        if (n < 0) {
            return;
        }
        if (n >= lArray.length) {
            return;
        }
        this.registerNestedArc(lArray[n]);
    }

    void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n2 = lArray.length;
        Object var6_6 = null;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        Object object = snmpRequestTree.getUserData();
        if (n >= n2) {
            throw new SnmpStatusException(6);
        }
        long l = lArray[n];
        if (this.isNestedArc(l)) {
            super.findHandlingNode(snmpVarBind, lArray, n, snmpRequestTree);
            return;
        }
        if (this.isTable(l)) {
            SnmpMibTable snmpMibTable = this.getTable(l);
            snmpMibTable.findHandlingNode(snmpVarBind, lArray, n + 1, snmpRequestTree);
        } else {
            this.validateVarId(l, object);
            if (n + 2 > n2) {
                throw noSuchInstanceException;
            }
            if (n + 2 < n2) {
                throw noSuchInstanceException;
            }
            if (lArray[n + 1] != 0L) {
                throw noSuchInstanceException;
            }
            snmpRequestTree.add(this, n, snmpVarBind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, int n2, SnmpRequestTree snmpRequestTree, AcmChecker acmChecker) throws SnmpStatusException {
        int n3 = lArray.length;
        Object var8_8 = null;
        if (snmpRequestTree == null) {
            throw noSuchObjectException;
        }
        Object object = snmpRequestTree.getUserData();
        int n4 = snmpRequestTree.getRequestPduVersion();
        if (n >= n3) {
            return super.findNextHandlingNode(snmpVarBind, lArray, n, n2, snmpRequestTree, acmChecker);
        }
        long l = lArray[n];
        long[] lArray2 = null;
        try {
            if (this.isTable(l)) {
                SnmpMibTable snmpMibTable = this.getTable(l);
                acmChecker.add(n2, l);
                try {
                    lArray2 = snmpMibTable.findNextHandlingNode(snmpVarBind, lArray, n + 1, n2 + 1, snmpRequestTree, acmChecker);
                }
                catch (SnmpStatusException snmpStatusException) {
                    throw noSuchObjectException;
                }
                finally {
                    acmChecker.remove(n2);
                }
                lArray2[n2] = l;
                return lArray2;
            }
            if (this.isReadable(l)) {
                if (n != n3 - 1) throw noSuchObjectException;
                lArray2 = new long[n2 + 2];
                lArray2[n2 + 1] = 0L;
                lArray2[n2] = l;
                acmChecker.add(n2, lArray2, n2, 2);
                try {
                    acmChecker.checkCurrentOid();
                }
                catch (SnmpStatusException snmpStatusException) {
                    throw noSuchObjectException;
                }
                finally {
                    acmChecker.remove(n2, 2);
                }
                snmpRequestTree.add(this, n2, snmpVarBind);
                return lArray2;
            }
            if (!this.isNestedArc(l)) throw noSuchObjectException;
            SnmpMibNode snmpMibNode = this.getChild(l);
            if (snmpMibNode == null) throw noSuchObjectException;
            acmChecker.add(n2, l);
            try {
                lArray2 = snmpMibNode.findNextHandlingNode(snmpVarBind, lArray, n + 1, n2 + 1, snmpRequestTree, acmChecker);
                lArray2[n2] = l;
                long[] lArray3 = lArray2;
                return lArray3;
            }
            finally {
                acmChecker.remove(n2);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            long[] lArray4 = new long[]{this.getNextVarId(l, object, n4)};
            return this.findNextHandlingNode(snmpVarBind, lArray4, 0, n2, snmpRequestTree, acmChecker);
        }
    }
}

