/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.model.impl;

import com.sun.xml.internal.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.internal.bind.v2.model.core.ClassInfo;
import com.sun.xml.internal.bind.v2.model.core.Element;
import com.sun.xml.internal.bind.v2.model.core.ElementInfo;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.PropertyKind;
import com.sun.xml.internal.bind.v2.model.core.ReferencePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import com.sun.xml.internal.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.ERPropertyInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.ElementInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.Messages;
import com.sun.xml.internal.bind.v2.model.impl.PropertySeed;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.runtime.IllegalAnnotationException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferencePropertyInfoImpl<T, C, F, M>
extends ERPropertyInfoImpl<T, C, F, M>
implements ReferencePropertyInfo<T, C> {
    private Set<Element<T, C>> types;
    private final boolean isMixed;
    private final WildcardMode wildcard;
    private final C domHandler;

    public ReferencePropertyInfoImpl(ClassInfoImpl<T, C, F, M> classInfoImpl, PropertySeed<T, C, F, M> propertySeed) {
        super(classInfoImpl, propertySeed);
        this.isMixed = propertySeed.readAnnotation(XmlMixed.class) != null;
        XmlAnyElement xmlAnyElement = propertySeed.readAnnotation(XmlAnyElement.class);
        if (xmlAnyElement == null) {
            this.wildcard = null;
            this.domHandler = null;
        } else {
            this.wildcard = xmlAnyElement.lax() ? WildcardMode.LAX : WildcardMode.SKIP;
            this.domHandler = this.nav().asDecl(this.reader().getClassValue(xmlAnyElement, "value"));
        }
    }

    public Set<? extends Element<T, C>> ref() {
        return this.getElements();
    }

    @Override
    public PropertyKind kind() {
        return PropertyKind.REFERENCE;
    }

    @Override
    public Set<? extends Element<T, C>> getElements() {
        if (this.types == null) {
            this.calcTypes(false);
        }
        assert (this.types != null);
        return this.types;
    }

    private void calcTypes(boolean bl) {
        Object object;
        this.types = new LinkedHashSet<Element<T, C>>();
        XmlElementRefs xmlElementRefs = this.seed.readAnnotation(XmlElementRefs.class);
        XmlElementRef xmlElementRef = this.seed.readAnnotation(XmlElementRef.class);
        if (xmlElementRefs != null && xmlElementRef != null) {
            this.parent.builder.reportError(new IllegalAnnotationException(Messages.MUTUALLY_EXCLUSIVE_ANNOTATIONS.format(this.nav().getClassName(this.parent.getClazz()) + '#' + this.seed.getName(), xmlElementRef.annotationType().getName(), xmlElementRefs.annotationType().getName()), (Annotation)xmlElementRef, xmlElementRefs));
        }
        if ((object = xmlElementRefs != null ? xmlElementRefs.value() : (xmlElementRef != null ? new XmlElementRef[]{xmlElementRef} : null)) != null) {
            Navigator navigator = this.nav();
            AnnotationReader annotationReader = this.reader();
            Object t = navigator.ref(XmlElementRef.DEFAULT.class);
            Object c = navigator.asDecl(JAXBElement.class);
            for (XmlElementRef xmlElementRef2 : object) {
                Object t2 = annotationReader.getClassValue(xmlElementRef2, "type");
                if (t2.equals(t)) {
                    t2 = navigator.erasure(this.getIndividualType());
                }
                boolean bl2 = navigator.getBaseClass(t2, c) != null ? this.addGenericElement(xmlElementRef2) : this.addAllSubtypes(t2);
                if (!bl || bl2) continue;
                if (t2.equals(navigator.ref(JAXBElement.class))) {
                    this.parent.builder.reportError(new IllegalAnnotationException(Messages.NO_XML_ELEMENT_DECL.format(this.getEffectiveNamespaceFor(xmlElementRef2), xmlElementRef2.name()), this));
                } else {
                    this.parent.builder.reportError(new IllegalAnnotationException(Messages.INVALID_XML_ELEMENT_REF.format(new Object[0]), this));
                }
                return;
            }
        }
        this.types = Collections.unmodifiableSet(this.types);
    }

    private boolean addGenericElement(XmlElementRef xmlElementRef) {
        String string = this.getEffectiveNamespaceFor(xmlElementRef);
        return this.addGenericElement(this.parent.owner.getElementInfo(this.parent.getClazz(), new QName(string, xmlElementRef.name())));
    }

    private String getEffectiveNamespaceFor(XmlElementRef xmlElementRef) {
        String string = xmlElementRef.namespace();
        if (string.length() == 0) {
            string = this.parent.builder.defaultNsUri;
        }
        return string;
    }

    private boolean addGenericElement(ElementInfo<T, C> elementInfo) {
        if (elementInfo == null) {
            return false;
        }
        this.types.add(elementInfo);
        for (ElementInfo<T, C> elementInfo2 : elementInfo.getSubstitutionMembers()) {
            this.addGenericElement(elementInfo2);
        }
        return true;
    }

    private boolean addAllSubtypes(T t) {
        Navigator navigator = this.nav();
        NonElement nonElement = this.parent.builder.getClassInfo(navigator.asDecl(t), this);
        if (!(nonElement instanceof ClassInfo)) {
            return false;
        }
        boolean bl = false;
        ClassInfo classInfo = (ClassInfo)nonElement;
        if (classInfo.isElement()) {
            this.types.add(classInfo.asElement());
            bl = true;
        }
        for (ClassInfoImpl typeInfoImpl : this.parent.owner.beans().values()) {
            if (!typeInfoImpl.isElement() || !navigator.isSubClassOf(typeInfoImpl.getType(), t)) continue;
            this.types.add(typeInfoImpl.asElement());
            bl = true;
        }
        for (ElementInfoImpl elementInfoImpl : this.parent.owner.getElementMappings(null).values()) {
            if (!navigator.isSubClassOf(elementInfoImpl.getType(), t)) continue;
            this.types.add(elementInfoImpl);
            bl = true;
        }
        return bl;
    }

    @Override
    protected void link() {
        super.link();
        this.calcTypes(true);
    }

    @Override
    public final boolean isMixed() {
        return this.isMixed;
    }

    @Override
    public final WildcardMode getWildcard() {
        return this.wildcard;
    }

    @Override
    public final C getDOMHandler() {
        return this.domHandler;
    }
}

