/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Messages;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XsiTypeLoader
extends Loader {
    private final JaxBeanInfo defaultBeanInfo;

    public XsiTypeLoader(JaxBeanInfo jaxBeanInfo) {
        super(true);
        this.defaultBeanInfo = jaxBeanInfo;
    }

    public void startElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        Loader loader;
        JaxBeanInfo jaxBeanInfo = XsiTypeLoader.parseXsiType(state, tagName);
        if (jaxBeanInfo == null) {
            jaxBeanInfo = this.defaultBeanInfo;
        }
        state.loader = loader = jaxBeanInfo.getLoader(null, false);
        loader.startElement(state, tagName);
    }

    static JaxBeanInfo parseXsiType(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        UnmarshallingContext unmarshallingContext = state.getContext();
        JaxBeanInfo jaxBeanInfo = null;
        Attributes attributes = tagName.atts;
        int n = attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (n >= 0) {
            String string = attributes.getValue(n);
            QName qName = DatatypeConverterImpl._parseQName(string, unmarshallingContext);
            if (qName == null) {
                XsiTypeLoader.reportError(Messages.NOT_A_QNAME.format(string), true);
            } else {
                jaxBeanInfo = unmarshallingContext.getJAXBContext().getGlobalType(qName);
                if (jaxBeanInfo == null) {
                    String string2 = unmarshallingContext.getJAXBContext().getNearestTypeName(qName);
                    if (string2 != null) {
                        XsiTypeLoader.reportError(Messages.UNRECOGNIZED_TYPE_NAME_MAYBE.format(qName, string2), true);
                    } else {
                        XsiTypeLoader.reportError(Messages.UNRECOGNIZED_TYPE_NAME.format(qName), true);
                    }
                }
            }
        }
        return jaxBeanInfo;
    }
}

