/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.jaxb;

import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.w3c.dom.Node;

public final class JAXBBridgeInfo {
    private final Bridge bridge;
    private Object value;

    public JAXBBridgeInfo(Bridge bridge) {
        this.bridge = bridge;
    }

    public JAXBBridgeInfo(Bridge bridge, Object object) {
        this(bridge);
        this.value = object;
    }

    public QName getName() {
        return this.bridge.getTypeReference().tagName;
    }

    public TypeReference getType() {
        return this.bridge.getTypeReference();
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public Object getValue() {
        return this.value;
    }

    public static JAXBBridgeInfo copy(JAXBBridgeInfo jAXBBridgeInfo) {
        return new JAXBBridgeInfo(jAXBBridgeInfo.getBridge(), jAXBBridgeInfo.getValue());
    }

    public void serialize(BridgeContext bridgeContext, OutputStream outputStream, NamespaceContext namespaceContext) {
        try {
            this.bridge.marshal(bridgeContext, this.value, outputStream, namespaceContext);
        }
        catch (JAXBException jAXBException) {
            throw new SerializationException(jAXBException);
        }
    }

    public void serialize(BridgeContext bridgeContext, XMLStreamWriter xMLStreamWriter) {
        try {
            this.bridge.marshal(bridgeContext, this.value, xMLStreamWriter);
        }
        catch (JAXBException jAXBException) {
            throw new SerializationException(jAXBException);
        }
    }

    public void serialize(BridgeContext bridgeContext, Node node) {
        try {
            this.bridge.marshal(bridgeContext, this.value, node);
        }
        catch (JAXBException jAXBException) {
            throw new SerializationException(jAXBException);
        }
    }

    public void deserialize(Source source, BridgeContext bridgeContext) {
        try {
            this.value = this.bridge.unmarshal(bridgeContext, source);
        }
        catch (JAXBException jAXBException) {
            throw new DeserializationException(jAXBException);
        }
    }

    public void deserialize(InputStream inputStream, BridgeContext bridgeContext) {
        try {
            this.value = this.bridge.unmarshal(bridgeContext, inputStream);
        }
        catch (JAXBException jAXBException) {
            throw new DeserializationException(jAXBException);
        }
    }

    public void deserialize(XMLStreamReader xMLStreamReader, BridgeContext bridgeContext) {
        try {
            this.value = this.bridge.unmarshal(bridgeContext, xMLStreamReader);
            if (xMLStreamReader.getEventType() == 4 && xMLStreamReader.isWhiteSpace()) {
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
            }
        }
        catch (JAXBException jAXBException) {
            throw new DeserializationException(jAXBException);
        }
    }
}

