package projman;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class Arrow implements Serializable {
	protected Point startPoint;
	protected Point endPoint;
	Entity from;
	Entity to;
	
	public Arrow(final Point2D p1, final Point2D p2, final Entity from, final Entity to) {
		startPoint = new Point();
		endPoint = new Point();
		setGeometry(p1, p2);
		this.from = from;
		this.to = to;
	}
		
	public void setGeometry(Point2D p1, Point2D p2) {
		try {
			startPoint.setLocation(p1);
			endPoint.setLocation(p2);
		} catch (NullPointerException e) {
			startPoint = null;
			endPoint = null;
		}
	}
	
	public void draw(Graphics2D g, Color color) {
		double spread = Math.toRadians(25);
		double length = 20;
		if (endPoint != null && startPoint != null) {
			//double-line width
			Stroke formerStroke = g.getStroke();
			g.setStroke(Config.thickLine);
			g.setColor(color);
			g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
			double lineAngle = Math.atan2((double)(endPoint.y - startPoint.y), (double)(startPoint.x - endPoint.x));
			double angle1 = lineAngle - spread;
			double angle2 = lineAngle + spread;
			Point p1 = new Point(endPoint.x + (int)(length*Math.cos(angle1)), endPoint.y - (int)(length*Math.sin(angle1)));
			Point p2 = new Point(endPoint.x + (int)(length*Math.cos(angle2)), endPoint.y - (int)(length*Math.sin(angle2)));
			g.drawLine(endPoint.x, endPoint.y, p1.x, p1.y);
			g.drawLine(endPoint.x, endPoint.y, p2.x, p2.y);
			//put us back endPoint single-line width
			g.setStroke(formerStroke);
			//Main.say("from " + startPoint + " to " + endPoint);
		}
	}
	
	public boolean intersects(Line2D.Float line) {
		return line.intersectsLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
	}
	
	@Override
	public String toString() {
		return "line from " + from.getName() + " to " + to.getName();
	}
	
	@Override
	public boolean equals(Object other) {
		boolean result = false;
		if (other instanceof Arrow) {
			if (startPoint.equals(((Arrow)other).startPoint)
					&& endPoint.equals(((Arrow)other).endPoint)) {
				result = true;
			}
		}
		return result;
	}
	

}
