package projman;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import projman.DiffWard.Status;

/**
 * See the FIXME comment in DiffWard.
 *
 */
public class DiffProject implements Comparable<DiffProject>, Serializable {
	private Project project;
	private Status projectStatus;
	private Map<Resource, Status> assignedResources;
	private Map<String, Resource> resourceNames;
	//private Map<String, Skill> skillNames;
	private Map<String, Status> associatedSkills;
	private Map<String, Integer> oldRequiredSkills;
	private Map<String, Integer> newRequiredSkills;

	public DiffProject(Project p, Status s) {
		project = p;
		projectStatus = s;
		assignedResources = new HashMap<Resource, Status>();
		associatedSkills = new HashMap<String, Status>();
		oldRequiredSkills = new HashMap<String, Integer>();
		newRequiredSkills = new HashMap<String, Integer>();
		resourceNames = new HashMap<String, Resource>();
		//skillNames = new HashMap<String, Skill>();
	}

	public boolean addSkill(Skill entity, Status status, int number) {
		if (status == Status.OLD) {
			oldRequiredSkills.put(entity.getName(), number);
		}
		if (status == Status.NEW) {
			newRequiredSkills.put(entity.getName(), number);
		}
		associatedSkills.put(entity.getName(), status);
		return true;
	}
	
	public Set<Resource> getResources() {
		return assignedResources.keySet();
	}
	
	public List<Resource> getSortedResources() {
		//Sort these so that NEW goes first, OLD goes second,
		//and SAME goes last.
		Set<Resource> unsorted = assignedResources.keySet();
		List<Resource> sortedResult = new ArrayList<Resource>();
		//TODO For now, I'm doing it the easy way.
		//Make more efficient if necessary.
		for (Resource r : unsorted) {
			if (assignedResources.get(r) == Status.NEW) {
				sortedResult.add(r);
			}
		}
		for (Resource r : unsorted) {
			if (assignedResources.get(r) == Status.OLD) {
				sortedResult.add(r);
			}
		}
		for (Resource r : unsorted) {
			if (assignedResources.get(r) == Status.SAME) {
				sortedResult.add(r);
			}
		}
		return sortedResult;
	}
	
	public DiffWard.Status getResourceStatus(Resource r) {
		String name = r.getName();
		Resource res = resourceNames.get(name);
		return assignedResources.get(res);
	}

	public Project getProject() {
		return project;
	}

	public DiffWard.Status getProjectStatus() {
		return projectStatus;
	}
	
	public Set<String> getAllAssociatedSkills() {
		return associatedSkills.keySet();
	}
	
//	public Status getSkillStatus(Skill s) {
//		return associatedSkills.get(s);
//	}
	
	public int getCountForSkill(String k, Status s) {
		Integer result = null;
		if (s == Status.OLD) {
			result = oldRequiredSkills.get(k);
		}
		if (s == Status.NEW) {
			result = newRequiredSkills.get(k);
		}
		if (result == null) return 0;
		else return result;
	}
	
	public DiffProject computeDifferences(Ward ward1, Ward ward2) {
		//if the project did not exist in one or the other of the two charts,
		//then there's no need to check whether its resources were assigned
		//to the project in both. Thus, add its resources to the "diffcomp"
		//either as "old" or "new", depending on whether the project existed
		//in chart 1 or chart 2, respectively.
		if (projectStatus == Status.OLD || projectStatus == Status.NEW) {
			Team comp = project.getTeam();
			if (comp != null) {
				for (Resource r : comp.getResources()) {
					addResource(r, projectStatus);
				}
			}
			//now do the same thing for the project's required skills
			Set<Skill> requiredSkills = project.getRequiredSkills();
			for (Skill rs : requiredSkills) {
				addSkill(rs, projectStatus, project.howManyNeeded(rs));
			}
		} else {
			//If the project does exist in both charts, then check to see which
			//of its resources also were assigned to it in chart 1, 2, or both.
			Team comp1 = ward1.getProjectByName(project.getName()).getTeam();
			Team comp2 = ward2.getProjectByName(project.getName()).getTeam();
			if (comp1 != null) {
				for (Resource r1 : comp1.getResources()) {
					if (comp2 == null || comp2.getResourceByName(r1.getName()) == null) {
						addResource(r1, Status.OLD);
					} else {
						addResource(r1, Status.SAME);
					}
				}
			}
			if (comp2 != null) {
				for (Resource r2 : comp2.getResources()) {
					if (comp1 == null || comp1.getResourceByName(r2.getName()) == null) {
						addResource(r2, Status.NEW);
					}
				}
			}

			//now find out which skills were assigned to the project, both in chart 1 and 2.
			List<Skill> unmatchedSkills1 = new LinkedList<Skill>();
			List<Skill> unmatchedSkills2 = new LinkedList<Skill>();
			Set<Skill> requiredSkills1 = ward1.getProjectByName(project.getName()).getRequiredSkills();
			Set<Skill> requiredSkills2 = ward2.getProjectByName(project.getName()).getRequiredSkills();
			for (Skill r : requiredSkills1) {
				unmatchedSkills1.add(r);
			}
			for (Skill r : requiredSkills2) {
				unmatchedSkills2.add(r);
			}

			for (Skill res1 : requiredSkills1) {
				for (Skill res2 : requiredSkills2) {
					if (res1.equals(res2)) {
						unmatchedSkills1.remove(res1);
						unmatchedSkills2.remove(res2);
						associatedSkills.put(res1.getName(), Status.SAME);
						oldRequiredSkills.put(res1.getName(), ward1.getProjectByName(project.getName()).howManyNeeded(res1));
						newRequiredSkills.put(res1.getName(), ward2.getProjectByName(project.getName()).howManyNeeded(res2));
						break;
					}
				}
			}
			for (Skill k : unmatchedSkills1) {
//				associatedSkills.put(k, Status.OLD);
//				oldRequiredSkills.put(k, ward1.getProjectByName(project.getName()).howManyNeeded(k));
				addSkill(k, Status.OLD, ward1.getProjectByName(project.getName()).howManyNeeded(k));
			}
			for (Skill k : unmatchedSkills2) {
//				associatedSkills.put(k, Status.NEW);
//				newRequiredSkills.put(k, ward2.getProjectByName(project.getName()).howManyNeeded(k));
				addSkill(k, Status.NEW, ward2.getProjectByName(project.getName()).howManyNeeded(k));
			}
		}

		return this;
	}
	
	private void addResource(Resource r, Status s) {
		assignedResources.put(r, s);
		resourceNames.put(r.getName(), r);
	}

	//TODO figure out why some compilers like this and some don't.
	//@Override
	public int compareTo(DiffProject o) {
		return project.compareTo(o.project);
	}


}
