package projman;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import projman.Ward.WardListener;

public class DiffWhiteboardTab extends AbstractWhiteboard implements WardListener {

	private DiffWard ward;
	private boolean dirty;

	public DiffWhiteboardTab(DiffWard ward) {
		super();
		this.ward = ward;
		teams = new ArrayList<WhiteboardTeam>();
		mouse = new DiffWhiteboardMouseHandler();
		addMouseMotionListener(mouse);
		addMouseListener(mouse);
		//recalibrateCards();
		dirty = true;
	}

	public void wardChanged() {
		ward.recomputeDifferences();
		//recalibrateCards();
		dirty = true;
		repaint();
	}

	@Override
	public void paintComponent(Graphics g1) {
		if (dirty) {
			recalibrateCards((Graphics2D)g1);
			dirty = false;
		}
		super.paintComponent(g1);
	}

	private void recalibrateCards(Graphics2D g) {
		//iterate through every project in the diffward.
		//Make a card, then a whiteboardteam for it.
		//Make cards for each of its resources.
		//Add the cards to the whiteboardteam; they should
		//arrange themselves.
		
		//TODO THINK: should we rearrange from scratch each
		//time?  What if the user wants to move the cards around?
		//That's nice; but perhaps not central to the research.
		//Save it for a future extension.
		
		if (!(windowSize.equals(getSize()))) {
			resize();
		}

		teams.clear();
		Point dummy = new Point();//start at upper-left corner
		for (DiffProject dp : ward.getAllProjects()) {
			//don't bother making cards if there are no resources assigned
			//to the project, either past or present.
			if (dp.getResources().size() > 0) {
				WhiteboardTeam newTeam = new WhiteboardTeam(this, dummy);
				WhiteboardCard projectCard = new WhiteboardCard(dp.getProject(),
						Project.getTeachingStatus(), dummy, g);
				projectCard.setDiffWard(ward);
				//Main.say("adding " + projectCard.getName() + " to newTeam");
				newTeam.add(projectCard);
				for (Resource r : dp.getSortedResources()) {
					WhiteboardCard resourceCard = new WhiteboardCard(r, Resource.getTeachingStatus(),
							dummy, g);
					resourceCard.setDiffWard(ward, dp.getResourceStatus(r));
					//Main.say("adding " + resourceCard.getName() + " to newTeam");
					newTeam.add(resourceCard);
				}
				teams.add(newTeam);
			}
		}
		arrangeTeamsNicely();
	}


	private class DiffWhiteboardMouseHandler extends WhiteboardMouseHandler {

		@Override
		public void mousePressed(MouseEvent e) {
			mousePos = e.getPoint();
			prevMousePos = mousePos;
			if (e.getButton() == 1) {
				if (lassoRect.contains(mousePos)) {
					return;
				}

				//if we've reached this point, then the click was
				//outside any existing team boundaries
				lassoPos = new Point(mousePos);
				lassoRect.setLocation(lassoPos);
				lassoRect.setSize(0,0);//necessary?
				draggedTeams.clear();
				setCursor(Cursor.getDefaultCursor());
			}
		}

		@Override
		public void mouseReleased(MouseEvent e) {
			mousePos = e.getPoint();
			setCursor(Cursor.getDefaultCursor());
			if (!draggedTeams.isEmpty()) {
				lassoRect = new Rectangle();
				draggedTeams.clear();
				repaint();
			}
			if (lassoPos != null) {
				//select all teams that fall within
				//the lasso's boundaries
				for (WhiteboardTeam wt : teams) {
					if (wt.intersects(lassoRect)) {
						draggedTeams.add(wt);
					}
				}
				if (draggedTeams.isEmpty()) {
					lassoRect = new Rectangle();
				} else {
					setCursor(Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR));
					lassoRect = WhiteboardTeam.computeUnion(draggedTeams);
				}
				lassoPos = null;
				repaint();
			}
		}

		@Override
		public void mouseDragged(MouseEvent e) {
			mousePos = e.getPoint();
			Point delta = new Point(mousePos.x-prevMousePos.x,
					mousePos.y-prevMousePos.y);
			if (!draggedTeams.isEmpty()) {
				for (WhiteboardTeam wt : draggedTeams) {
					wt.translate(delta);
				}
				lassoRect.translate(delta.x, delta.y);
			}
			prevMousePos = mousePos;
			repaint();
		}

	}


	@Override
	protected void drawAdditional(Graphics2D g) {
		// TODO Auto-generated method stub
		
	}

}
