package projman;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

import projman.Project.Priority;

import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JSpinnerDateEditor;

public class EditProjectDialog extends JDialog implements ActionListener {
	
	private Project brother;
	private JTextField nameTextField;
	private JDateChooser deadlineWidget;
	private JSpinner percentWidget;
	private JComboBox priorityWidget;
	private static final long serialVersionUID = 42L;
	
	public EditProjectDialog(Dialog parent, boolean existing, Project guy) {
		super(parent, true);
		init(existing, guy, parent);
	}
	
	public EditProjectDialog(Frame parent, boolean existing, Project guy) {
		super(parent, true);
		init(existing, guy, parent);
	}
	
	private void init(boolean existing, Project guy, Component parent) {
		if (existing) {
			setTitle(Main.messages.getString(Constants.EDIT_PROJECT_DIALOG_TITLE));
		} else {
			setTitle(Main.messages.getString(Constants.ADD_NEW_PROJECT_DIALOG_TITLE));
		}
		this.brother = guy;
		buildGUI(existing);
		setResizable(false);
		pack();
		
		//position this dialog in the middle of its parent window
		Rectangle parentBounds = parent.getBounds();
		Dimension mySize = getSize();
		setLocation(parentBounds.x + parentBounds.width/2 - mySize.width/2,
				parentBounds.y + parentBounds.height/2 - mySize.height/2);
		
		
		//treat a window-closing event as if the user
		//had clicked the "cancel" button.
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent event) {
				handleActionEvent(Constants.CANCEL_BUTTON_LABEL);
			}
		});
		
		setVisible(true);
		
	}
	
	private void buildGUI(boolean editExisting) {
		//setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
		GridBagLayout grid = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		setLayout(grid);
		
		//JPanel namePanel = new JPanel();
		JLabel nameLabel = new JLabel(Main.messages.getString(Constants.ENTER_PROJECT_NAME_DIALOG_LABEL));
		c = new GridBagConstraints();
		c.weightx = 1.0;
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(nameLabel, c);
		
		nameTextField = new JTextField();
		if (!editExisting) {
			nameTextField.setText(Main.messages.getString(Constants.DEFAULT_PROJECT_NAME));
			nameTextField.select(0, Main.messages.getString(Constants.DEFAULT_PROJECT_NAME).length());
		} else {
			nameTextField.setText(brother.getName());
		}
		c.gridwidth = GridBagConstraints.REMAINDER;
		grid.setConstraints(nameTextField, c);
		
		//let the user enter the project deadline
		//JPanel deadlinePanel = new JPanel();
		JLabel deadlineLabel = new JLabel("Deadline");
		c = new GridBagConstraints();
		c.weightx = 1.0;
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(deadlineLabel, c);
		deadlineWidget = new JDateChooser(null, null, null,
				new JSpinnerDateEditor());
		deadlineWidget.setCalendar(brother.getDeadline());
		c.gridwidth = GridBagConstraints.REMAINDER;
		grid.setConstraints(deadlineWidget, c);
		
		//JPanel priorityPanel = new JPanel();
		JLabel priorityLabel = new JLabel("Priority: ");
		c = new GridBagConstraints();
		c.weightx = 1.0;
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(priorityLabel, c);
		priorityWidget = new JComboBox();
		priorityWidget.addItem(Priority.Low.toString());
		priorityWidget.addItem(Priority.Normal.toString());
		priorityWidget.addItem(Priority.High.toString());
		priorityWidget.addItem(Priority.Critical.toString());
		priorityWidget.setSelectedItem(brother.getPriority().toString());
		c.gridwidth = GridBagConstraints.REMAINDER;
		grid.setConstraints(priorityWidget, c);
		
		//JPanel percentPanel = new JPanel();
		JLabel percentLabel = new JLabel("Percent Complete: ");
		c = new GridBagConstraints();
		c.weightx = 1.0;
		c.fill = GridBagConstraints.BOTH;
		grid.setConstraints(percentLabel, c);
		SpinnerModel spinnerModel =
			new SpinnerNumberModel(brother.getPercentComplete(), //initial value
					0, //min
					100, //max
					1);                //step
		percentWidget = new JSpinner(spinnerModel);
		c.gridwidth = GridBagConstraints.REMAINDER;
		grid.setConstraints(percentWidget, c);
		
		JPanel okCancelPanel = new JPanel();
		okCancelPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		JButton okButton = new JButton(Main.messages.getString(Constants.OK_BUTTON_LABEL));
		getRootPane().setDefaultButton(okButton);
		JButton cancelButton = new JButton(Main.messages.getString(Constants.CANCEL_BUTTON_LABEL));
		okCancelPanel.add(okButton);
		okCancelPanel.add(cancelButton);
		c = new GridBagConstraints();
		c.weightx = 1.0;
		c.fill = GridBagConstraints.REMAINDER;
		grid.setConstraints(okCancelPanel, c);
		
		
		okButton.setActionCommand(Constants.OK_BUTTON_LABEL);
		cancelButton.setActionCommand(Constants.CANCEL_BUTTON_LABEL);
		okButton.addActionListener(this);
		cancelButton.addActionListener(this);
		
		add(nameLabel);
		add(nameTextField);
		add(deadlineLabel);
		add(deadlineWidget);
		add(priorityLabel);
		add(priorityWidget);
		add(percentLabel);
		add(percentWidget);
//		add(namePanel);
//		add(deadlinePanel);
//		add(priorityPanel);
//		add(percentPanel);
		add(new JPanel());//space filler
		add(okCancelPanel);
	}
	
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		handleActionEvent(command);
	}
	
	private void handleActionEvent(String command) {
		// TODO Auto-generated method stub
		if (command.equals(Constants.CANCEL_BUTTON_LABEL)) {
			brother.setChanged(false);
		}
		if (command.equals(Constants.OK_BUTTON_LABEL)) {
			brother.setName(nameTextField.getText());
			brother.setDeadline(deadlineWidget.getCalendar());
			brother.setPercentComplete((Integer)percentWidget.getValue());
			brother.setPriority(Priority.valueOf((String)priorityWidget.getSelectedItem()));
//			brother.setWillingToTeach(isAHomeTeacher.getResult());
//			brother.setAuxiliaryAffiliation(quorumAssignedTo.getResult());
//			brother.setHusbandWifeCompanionship(withSpouse.getResult());
			brother.setChanged(true);
		}
		setVisible(false);
	}
	
	public Project getProject() {
		return brother;
	}
}
