package projman;


import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

import javax.swing.JComponent;
import javax.swing.TransferHandler;

import projman.CandidateList.TeachingJList;

public class EntityTransferHandler extends TransferHandler {

	private static final long serialVersionUID = 7L;
	private boolean successfulDrop = false;
	private WhiteboardWidget whiteboard = null;

	private static DataFlavor dataFlavor;

	public EntityTransferHandler() {
		getMemberDataFlavor();
	}

	@Override
	protected Transferable createTransferable(JComponent c) {
		//Main.say("inside createTransferable, c=" + c.toString());
		if (c instanceof TeachingJList) {
			Object obj = ((TeachingJList)c).getSelectedValue();
			EntityStatus status = ((TeachingJList)c).status;
			if (obj instanceof Entity) {
				Entity selection = (Entity)obj;
//				Main.say("wrapping " + selection.getName() + " up as a Transferable!");
				return new DraggedSelection(selection, status);
			}
		}
		if (c instanceof WhiteboardWidget) {
			WhiteboardCard card = ((WhiteboardWidget)c).getSelectedCard();
			Entity selection = card.getEntity();
			EntityStatus status = card.getTeachingStatus();
			//Main.say("wrapping " + selection.getName() + " up as a Transferable!");
			return new DraggedSelection(selection, status);
		}
		return null;
	}

	@Override
	public int getSourceActions(JComponent c) {
		//Main.say("inside getSourceActions");
		return COPY;
	}

	@Override
	protected void exportDone(JComponent source,
			Transferable data,
			int action) {
		super.exportDone(source, data, action);
		if (!successfulDrop) {
			if (source instanceof WhiteboardWidget) {
				((WhiteboardWidget)source).restoreCardAfterBadDrop();
			}
		} else {
			if (source instanceof WhiteboardWidget) {
				((WhiteboardWidget)source).cleanupAfterDrop();
			}
		}
//		Main.say("---------------------------");
	}

//	@Override
//	public void exportAsDrag(JComponent comp,
//			InputEvent e,
//			int action)  {
//		super.exportAsDrag(comp, e, action);
//		Main.say("export as drag!");
//	}

	public static DataFlavor getMemberDataFlavor() {
		//Main.say("inside getMemberDataFlavor");
		if (dataFlavor == null) {
			String mimeType = DataFlavor.javaJVMLocalObjectMimeType +
			";class=projman.Entity";
			try {
				dataFlavor = new DataFlavor(mimeType);
			} catch (ClassNotFoundException e) { 
				Main.say("this should never happen. :-)");
			}
		}
		return dataFlavor;
	}

	//requires JDK1.6
	@Override
	public boolean importData(TransferHandler.TransferSupport support) {
//		Main.say("importData!");
		Transferable t = support.getTransferable();
		Component c = support.getComponent();
		boolean success = true;
		if (supportsOurDataFlavor(t.getTransferDataFlavors())) {
			try {
				DraggedSelection sel = (DraggedSelection)t.getTransferData(dataFlavor);
				Entity entity = sel.getEntity();
				EntityStatus status = sel.getTeachingStatus();
//				Main.say("dragged: " + entity.getName());
				if (c instanceof WhiteboardWidget) {
					((WhiteboardWidget)c).handleDrop(entity, status,
							support.getDropLocation().getDropPoint());
				}
				if (c instanceof TeachingJList) {
//					Main.say("attempting to drop " + entity +
//							" on JList");
					success = ((TeachingJList)c).handleDrop(entity, status);
				}
//				if (c instanceof CandidateList) {
//					Main.say("attempting to drop " + entity +
//					" on CandidateList");
//				}
				return success;
			} catch (UnsupportedFlavorException ufe) {
				System.out.println("importData: unsupported data flavor");
			} catch (IOException ioe) {
				System.out.println("importData: I/O exception");
			}
		}
		return false;
	}

	/**
	 * Does the flavor list support our type of data flavor?
	 */
	protected boolean supportsOurDataFlavor(DataFlavor[] flavors) {
		//Main.say("inside supportsOurDataFlavor()");
		if (dataFlavor == null) {
			return false;
		}

		for (int i = 0; i < flavors.length; i++) {
			if (dataFlavor.equals(flavors[i])) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean canImport(TransferHandler.TransferSupport support) {
//		Main.say("can import?");
		Transferable t = support.getTransferable();
		Component c = support.getComponent();
		successfulDrop = false;
		if (supportsOurDataFlavor(t.getTransferDataFlavors())) {
			try {
				DraggedSelection sel = (DraggedSelection)t.getTransferData(EntityTransferHandler.getMemberDataFlavor());
				EntityStatus status = sel.getTeachingStatus();
				//Main.say("dragged: " + entity.getName());
				if (c instanceof WhiteboardWidget) {
					whiteboard = (WhiteboardWidget)c;
					successfulDrop = true;//whiteboard.canAccept();
						whiteboard.updateGhostCard(sel.getEntity(),
							status, support.getDropLocation().getDropPoint());
				}
				if (c instanceof TeachingJList) {					
					successfulDrop = (status == ((TeachingJList)c).status);
					if (whiteboard != null) {
						whiteboard.updateGhostCard(null, null, null);
						//Main.say("setting ghostcard to NULL");
					}
				}
			} catch (UnsupportedFlavorException ufe) {
				System.out.println("importData: unsupported data flavor");
			} catch (IOException ioe) {
				System.out.println("importData: I/O exception");
			}
		}
		//Main.say("can drop=" + successfulDrop);
		return successfulDrop;

	}
}
