package projman;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.Vector;
import java.awt.BasicStroke;


public class Gesture {
	private Vector<Point> points;

	public Gesture(Point p) {
		points = new Vector<Point>();
		points.add(p);
	}

	public void addPoint(Point p) {
		points.add(p);
	}

	public Line2D.Float getLine() {
		if (points.size() < 2) return null;
		
		//only accept lines that are relatively straight.
		//if the user drew all over the place; reject the line.
		if (getEndPointDistance()/getRawDistance() < 0.8) return null;

		return new Line2D.Float(points.firstElement(), points.lastElement());
	}

	public void draw(Graphics2D g) {
		if (points.size() < 2) return;
		
			BasicStroke stroke = new BasicStroke(2);
			g.setStroke(stroke);


		for (int i=1; i<points.size(); ++i) {
			g.drawLine(points.get(i-1).x, points.get(i-1).y, points.get(i).x, points.get(i).y);
		}
		
		g.setStroke(new BasicStroke());
	}

	//assumes there are two more more points
	private double getRawDistance() {
		double result = 0;
		for (int i=1; i<points.size(); ++i) {
			result += points.get(i-1).distance(points.get(i));
		}
		return result;
	}

	//assumes there are two more more points
	private double getEndPointDistance() {
		return points.firstElement().distance(points.lastElement());
	}

}
