package projman;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

//This composite class gives me the precision of the new Path2D
//class, while still providing the low-level access to individual
//vertices I got accustomed to when using the legacy Polygon class.

public class HyrumPolygon implements Serializable {
	private Path2D.Float polygon;
	private List<Point2D.Float> points;
	
	public HyrumPolygon() {
		polygon = new Path2D.Float(Path2D.WIND_EVEN_ODD);
		points = new ArrayList<Point2D.Float>();
	}
	
	public void addPoint(Point2D.Float p) {
		addPoint(p.x, p.y);
	}
	
	public void addPoint(float x, float y) {
		if (points.isEmpty()) {
			polygon.moveTo(x, y);
		} else {
			polygon.lineTo(x, y);
		}
		points.add(new Point2D.Float(x,y));
	}
	
	public Point2D.Float getPointAt(int index) {
		return points.get(index);
	}
	
	public int getNumPoints() {
		return points.size();
	}
	
	//trivial delegate methods
	public void closePath() {
		if (points.size() > 2) {
			polygon.closePath();
		}
	}
	
	public void reset() {
		polygon.reset();
		points.clear();
	}
	
	public void fill(Graphics2D g) {
		g.fill(polygon);
	}
	
	public void draw(Graphics2D g) {
		g.draw(polygon);
	}
	
	public void transform(AffineTransform at) {
		polygon.transform(at);
	}
	
	public boolean contains(Point2D p) {
		return polygon.contains(p);
	}
}
