package projman;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.swing.ImageIcon;

public class Project implements ProjectBase {

	private static final long serialVersionUID = 42L;

	public enum Priority {
		NONE,//not used; here only for mathematical convenience
		Low,
		Normal,
		High,
		Critical
	}

	private boolean changed;
	private String name;
	private Team assignedResources;
	private Calendar deadline;
	private Priority priority;
	private int percentComplete;
	private Map<Skill, Integer> requiredSkills;
	private Ward ward;
	
	public Project(Ward ward) {
		changed = false;
		name = Main.messages.getString(Constants.DEFAULT_PROJECT_NAME);
		assignedResources = null;
		this.ward = ward;
		percentComplete = 0;
		priority = Priority.Normal;
		deadline = Calendar.getInstance();
		requiredSkills = new HashMap<Skill, Integer>();
	}
	
	public boolean isChanged() {
		return changed;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public void setChanged(boolean changed) {
		this.changed = changed;
	}

	public Team getTeachers() {
		return assignedResources;
	}
	
	public Team getTeam() {
		return getTeachers();
	}

	public void removeTeachers() {
		assignedResources = null;
	}

	public void setTeachers(Team teachers) {
		assignedResources = teachers;
	}

	public String getName() {
		return name;
	}

	public int compareTo(Entity o) {
		int result = 0;
		if (o instanceof Project){
			Project other = (Project)o;
			result = -(this.deadline.compareTo(other.deadline));
		}
		return result;
	}

	public Calendar getDeadline() {
		return deadline;
	}

	public void setDeadline(Calendar other) {
		this.deadline.setTime(other.getTime());
	}
	
	public int getPercentComplete() {
		return percentComplete;
	}

	public void setPercentComplete(int percentComplete) {
		this.percentComplete = percentComplete;
	}

	public Priority getPriority() {
		return priority;
	}

	public void setPriority(Priority priority) {
		this.priority = priority;
	}
	
	public void addSkill(Skill s) {
		Integer count = requiredSkills.get(s);
		if (count == null) {
			count = 0;
		}
		++count;
		requiredSkills.put(s, count);
	}
	
	public boolean removeSkillRequirementFor(Skill s) {
		boolean result = false;
		Integer count = requiredSkills.get(s);
		//handle the case in which we remove a skill that wasn't required to start with.
		if (count != null) {
			--count;
			requiredSkills.put(s, count);
			result = true;
		}
		return result;
	}
	
	public void removeAllSkillRequirementsFor(Skill s) {
		if (s != null) {
			requiredSkills.remove(s);
		}
	}
	
	public boolean requiresSkill(Skill s) {
		return requiredSkills.containsKey(s);
	}
	
	public int howManyNeeded(Skill s) {
		Integer result;
		result = requiredSkills.get(s);
		if (result == null) result = 0;
		return result;
	}
	
	public int howManyOfOurResourcesHaveThisSkill(Skill s) {
		int result = 0;
		if (assignedResources != null) {
			result = assignedResources.howManyOfThisSkillAreCurrentlyAssignedToThisProject(s);
		}
		return result;
	}
	
	public Set<Skill> getRequiredSkills() {
		return requiredSkills.keySet();
	}

	@Override
	public String toString() {
		StringBuilder buff = new StringBuilder();
		buff.append("name: ");
		buff.append(name);
		buff.append("\n priority: ");
		buff.append(priority.toString());
		buff.append("\n% complete: ");
		buff.append(percentComplete);
		buff.append("\ndeadline: ");
		buff.append(deadline.toString());
		return new String(buff);
	}

	public boolean attemptToAffiliate(Entity other) {
		if (other instanceof Project) return false;
		if (other instanceof Skill) {
			Skill skill = (Skill)other;
			addSkill(skill);
			return true;
		}
		if (other instanceof Resource) {
			Resource res = (Resource)other;
			if (assignedResources != null) {
				if (assignedResources.getAllTeachers().contains(res)) return false;
			} else {
				assignedResources = new Team();
				assignedResources.addProject(this);
			}
			assignedResources.addResource(res);
			//getWard().assignmentsChanged();
			return true;
		}
		return false;
	}
	
	public boolean attemptToDisaffiliate(Entity other) {
		boolean result = false;
		if (other instanceof Skill) {
			result = removeSkillRequirementFor((Skill)other);
			//getWard().assignmentsChanged();
		}
		return result;
	}
	
	public void setWillingToBeTaught(boolean willing) {}
	public Auxiliary getAuxiliaryAffiliation() { return Config.DEFAULT_AUX; }
	public boolean isWillingToBeTaught() { return false; }
	public ImageIcon getPhoto() { return null; }
	public void setAuxiliaryAffiliation(Auxiliary aux) {}
	public void setPhoto(String filename) {}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof Project)) return false;
		else {
			return (name.equals(((Project)o).name));
		}
	}
	
	public Ward getWard() {
		return ward;
	}
	
	public static EntityStatus getTeachingStatus() {
		return EntityStatus.RESOURCE;
	}

}
