package projman;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectSelectorDialog extends JDialog implements ActionListener {
	private JList projectListBox;
	private DefaultListModel listModel;
	private Ward ward;
	private Auxiliary currentAuxiliary;
	private static final long serialVersionUID = 42L;

	public ProjectSelectorDialog(Frame parent, boolean invokedFromMenuBar) {
		super(parent, Main.messages.getString(Constants.SELECT_PROJECT_DIALOG_LABEL), true);
		this.ward = Main.getWard();
		this.currentAuxiliary = Config.DEFAULT_AUX;
		buildGUI(invokedFromMenuBar);
		setResizable(false);
		pack();

		//position this dialog in the middle of its parent window
		Rectangle parentBounds = parent.getBounds();
		Dimension mySize = getSize();
		setLocation(parentBounds.x + parentBounds.width/2 - mySize.width/2,
				parentBounds.y + parentBounds.height/2 - mySize.height/2);

		setVisible(true);
	}

	public ProjectSelectorDialog(Frame parent) {
		this(parent, true);
	}

	private void buildGUI(boolean invokedFromMenuBar) {
		setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
		JLabel label;
//		if (invokedFromMenuBar) {
//			label = new JLabel(Main.messages.getString(Constants.ENTER_FAMILY_NAME_DIALOG_LABEL));
//		} else {
//			label = new JLabel(Main.messages.getString(Constants.ADD_NEW_PERSON_BY_EDITING_FAMILY));
//		}
		label = new JLabel(Main.messages.getString(Constants.ENTER_PROJECT_NAME_DIALOG_LABEL));
		add(label);
		listModel = new DefaultListModel();
		projectListBox = new JList(listModel);
		projectListBox.setCellRenderer(new MyCellRenderer());
		MouseListener mouseListener = new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() == 2) {
					handleActionEvent(Constants.EDIT_BUTTON_LABEL);
				}
			}
		};
		projectListBox.addMouseListener(mouseListener);
		JScrollPane listScroller = new JScrollPane(projectListBox);
		add(listScroller);

		add(createButtonPanel());
		refresh();
	}

	private JPanel createButtonPanel() {
		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.PAGE_AXIS));
		JPanel row1 = new JPanel();
		JPanel row2 = new JPanel();
		row1.setLayout(new BoxLayout(row1, BoxLayout.LINE_AXIS));
		row2.setLayout(new BoxLayout(row2, BoxLayout.LINE_AXIS));
		final JButton addNewFamilyButton = new JButton(Main.messages.getString(Constants.ADD_NEW_BUTTON_LABEL));
		addNewFamilyButton.setActionCommand(Constants.ADD_NEW_BUTTON_LABEL);
		addNewFamilyButton.addActionListener(this);
		final JButton editFamilyButton = new JButton(Main.messages.getString(Constants.EDIT_BUTTON_LABEL));
		editFamilyButton.setActionCommand(Constants.EDIT_BUTTON_LABEL);
		editFamilyButton.addActionListener(this);
		final JButton deleteFamilyButton = new JButton(Main.messages.getString(Constants.DELETE_BUTTON_LABEL));
		deleteFamilyButton.setActionCommand(Constants.DELETE_BUTTON_LABEL);
		deleteFamilyButton.addActionListener(this);
		row1.add(addNewFamilyButton);
		row1.add(Box.createRigidArea(new Dimension(5,0)));
		row1.add(editFamilyButton);
		row1.add(Box.createRigidArea(new Dimension(5,0)));
		row1.add(deleteFamilyButton);
		enableOrDisableButtons(projectListBox, editFamilyButton, deleteFamilyButton);
		projectListBox.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				if (e.getValueIsAdjusting() == false) {
					enableOrDisableButtons(projectListBox,
							editFamilyButton,
							deleteFamilyButton);
				}
			}
		});
		final JButton doneButton = new JButton(Main.messages.getString(Constants.DONE_BUTTON_LABEL));
		doneButton.setActionCommand(Constants.DONE_BUTTON_LABEL);
		doneButton.addActionListener(this);
		row2.add(doneButton);
		buttonPane.add(row1);
		buttonPane.add(Box.createRigidArea(new Dimension(0,5)));
		buttonPane.add(row2);
		//TODO add a big "Done" button at the bottom.
		return buttonPane;
	}

	private void enableOrDisableButtons(JList list, JButton ed, JButton del) {
		ed.setEnabled(true);
		del.setEnabled(true);
		if (list.getSelectedIndex() == -1) {
			//No selection, disable edit/delete buttons.
			ed.setEnabled(false);
			del.setEnabled(false);
		} else {
			//Multiple sections, disable edit button
			if (list.getSelectedIndices().length > 1) {
				ed.setEnabled(false);
			}
		}
	}


	private void refresh() {
		listModel.clear();
		for (Project f : ward.getAllProjects()) {
			listModel.addElement(f);
		}
	}

	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		handleActionEvent(command);
	}

	//FIXME: multiple families do not delete correctly!
	private void handleActionEvent(String command) {
		if (command.equals(Constants.ADD_NEW_BUTTON_LABEL)) {
			ward.displayNewProjectDialog(this, currentAuxiliary);
		}
		if (command.equals(Constants.EDIT_BUTTON_LABEL)) {
			Project fam = (Project)projectListBox.getSelectedValue();
			ward.displayEditProjectDialog(this, fam);
		}
		if (command.equals(Constants.DELETE_BUTTON_LABEL)) {
			int indices[] = projectListBox.getSelectedIndices();
			ward.deleteProjects(listModel, indices);
		}
		if (command.equals(Constants.DONE_BUTTON_LABEL)) {
			setVisible(false);
		}
		refresh();
	}

	private class MyCellRenderer extends JLabel implements ListCellRenderer {

		private static final long serialVersionUID = 42L;

		public Component getListCellRendererComponent(
				JList list,
				Object value,            // value to display
				int index,               // cell index
				boolean isSelected,      // is the cell selected
				boolean cellHasFocus)    // the list and the cell have the focus
		{
			String s = "";
			if (value instanceof Project) {
				s = ((Project)value).getName();
			}
			setText(s);
			if (isSelected) {
				setBackground(list.getSelectionBackground());
				setForeground(list.getSelectionForeground());
			}
			else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}
			setEnabled(list.isEnabled());
			setFont(list.getFont());
			setOpaque(true);
			return this;
		}
	}

}
