package projman;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.ImageIcon;

public class Resource implements ResourceBase {
	
	private static final long serialVersionUID = 42L;
	private String name;
	private List<Team> teams;
	private Map<Team, Double> percentOfTimeSpentOnEachProject;
						//we use doubles instead of floats because the little
						//colored blocks were rendering incorrectly.
	private Set<Skill> skillSet; 
	private boolean changed;
	private double capacity;
//	private DiffStatus diff;
	private Ward ward;

	
	public Resource(Ward ward) {
		name = Main.messages.getString(Constants.DEFAULT_RESOURCE_NAME);
		changed = false;
		teams = new ArrayList<Team>();
		skillSet = new HashSet<Skill>();
		percentOfTimeSpentOnEachProject = new HashMap<Team, Double>();
		capacity = 1.0;
		this.ward = ward;
//		diff = DiffStatus.SAME;
	}
	
	public Ward getWard() {
		return ward;
	}

	@Override
		public String toString() {
		return getName();
	}
	
	public boolean isChanged() {
		return changed;
	}
	
	public void setChanged(boolean changed) {
		this.changed = changed;
	}
	
	//this method is only intended to be called by
	//Companionship.addTeacher() and by no one else.
	public void addToCompanionship(Team comp) {
		//To figure out how much time I can spend on this project (comp):
		//See how many projects I currently have (n).
		//Reassign the other projects' priority to p-1/(n*(n+1))
		//where p is their prior priority.
		//Give the newest project 1/(n+1) of my time.
		double n = teams.size();
		for (Team c : teams) {
			double p = getPercentageOfTimeSpentOnThisProject(c);
			setPercentageOfTimeSpentOnThisProject(c, p-1f/(n*(n+1f)));
		}		
		teams.add(comp);
		setPercentageOfTimeSpentOnThisProject(comp, 1f/(n+1f));
	}
	
	public List<Team> getCompanionships() {
		return teams;
	}

	public Team[] getCompanionshipsAsArray() {
		return teams.toArray(new Team[]{});
	}
	
	public double getPercentageOfTimeSpentOnThisProject(Team comp) {
		return percentOfTimeSpentOnEachProject.get(comp);
	}
	
	public void setPercentageOfTimeSpentOnThisProject(Team comp, double percent) {
		percentOfTimeSpentOnEachProject.put(comp, percent);
	}
	
	//this method is only intended to be called by
	//Companionship.removeTeacher() and by no one else.
	public void removeFromCompanionship(Team comp) {
		double residue = getPercentageOfTimeSpentOnThisProject(comp);
		teams.remove(comp);
		
		//divide up how much time was devoted to the defunct
		//project by how many are left, and add that amount
		//to each project.
		double n = teams.size();
		for (Team c : teams) {
			double p = getPercentageOfTimeSpentOnThisProject(c);
			setPercentageOfTimeSpentOnThisProject(c, p+residue/n);
		}		

	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public boolean addSkill(Skill s) {
		boolean result = skillSet.add(s);
		for (Team c : teams) {
			c.updateAssignedSkills();
		}
		return result;
	}
	
	public boolean removeSkill(Skill s) {
		boolean result = skillSet.remove(s);
		for (Team c : teams) {
			c.updateAssignedSkills();
		}
		return result;
	}
	
	public boolean possessesSkill(Skill s) {
		return skillSet.contains(s);
	}
	
	public boolean possessesSkill(String s) {
		boolean result = false;
		for (Skill k : skillSet) {
			if (s.equals(k.getName())) {
				result = true;
				break;
			}
		}
		return result;
	}
	
	public Set<Skill> getSkillSet() {
		return skillSet;
	}
	
	public int compareTo(Entity o) {
		int result = 0;
		if (o instanceof Resource){
			Resource other = (Resource)o;
			result = this.name.compareToIgnoreCase(other.name);
		}
		return result;
	}
	
	@Override
	public boolean equals(Object o) {
		if (!(o instanceof Resource)) return false;
		return (name.equals(((Resource)o).getName()));
	}
	
	public ImageIcon getPhoto() { return null; }
	public void setAuxiliaryAffiliation(Auxiliary aux) {}
	public void setPhoto(String filename) {}
	public void setHusbandWifeCompanionship(boolean isHusbandWifeCompanionship) {}
	public void setWillingToTeach(boolean willing) {}
	public Auxiliary getAuxiliaryAffiliation() { return Config.DEFAULT_AUX;	}
	public boolean isHusbandWifeCompanionship() { return false; }
	public boolean isWillingToTeach() { return false; }
	
	public double getCapacity() {
		return capacity;
	}
	
	public void setCapacity(double capacity) {
		this.capacity = capacity;
	}
	
	public boolean attemptToAffiliate(Entity other) {
		if (other instanceof Resource) return false;
		if (other instanceof Skill) {
			Skill skill = (Skill)other;
			if (skillSet.contains(skill)) return false;
			addSkill(skill);
			return true;
		}
		if (other instanceof Project) {
			Team proj = ((Project)other).getTeachers();
			if (proj != null) {
				for (Team team : teams) {
					if (team.equals(proj)) {
						return false;
					}
				}
			} else {
				proj = new Team();
				proj.addProject((Project)other);
			}
			proj.addResource(this);
			return true;
		}
		return false;
	}
	
	public boolean attemptToDisaffiliate(Entity other) {
		boolean result = false;
		if (other instanceof Project) {
			Team relationshipToSever = null;
			Project proj = (Project)other;
			loop:
			for (Team team : teams) {
				for (ProjectBase candidate : team.getAllTeachees()) {
					if (candidate.equals(proj)) {
						relationshipToSever = team;
						break loop;
					}
				}
			}
			if (relationshipToSever != null) {
				result = relationshipToSever.removeResource(this);
			}
		}
		if (other instanceof Skill) {
			result = removeSkill((Skill)other);
		}
		return result;
	}
	
//	public DiffStatus getDiffStatus() {
//		return diff;
//	}
//
//	public void setDiffStatus(DiffStatus ds) {
//		diff = ds;		
//	}

	public static EntityStatus getTeachingStatus() {
		return EntityStatus.PROJECT;
	}


	
}
