package projman;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Team implements Serializable, Comparable<Team> {
	private List<ResourceBase> teachers;
	private List<ProjectBase> teachees;
	private Map<Skill, Integer> assignedSkills;
	//private Map<TeacherOrTeachee, DiffStatus> diff;
	private static final long serialVersionUID = 42L;
	
	public Team() {
		teachers = new ArrayList<ResourceBase>();
		teachees = new ArrayList<ProjectBase>();
		assignedSkills = new HashMap<Skill, Integer>();
		//diff = new HashMap<TeacherOrTeachee, DiffStatus>();
	}
	
	public void addProject(Project proj) {
		addTeachee(proj);
	}
	
	public Project getProject() {
		Project result = null;
		if (teachees.size() > 0) {
			result = (Project)teachees.get(0);
		}
		return result;
	}
	
	public List<Resource> getResources() {
		List<Resource> hack = new ArrayList<Resource>();
		for (ResourceBase t : getAllTeachers()) {
			hack.add((Resource)t);
		}
		return hack;
	}
	
	public Resource getResourceByName(String name) {
		Resource result = null;
		for (ResourceBase t : getAllTeachers()) {
			if (t.getName().equals(name)) {
				result = (Resource)t;
				break;
			}
		}
		return result;
	}
	
	public void addResource(Resource res) {
		addTeacher(res);
	}
	
	public void removeProject(Project proj) {
		removeTeachee(proj);
	}
	
	public void disband() {
		Project p = getProject();
		if (p != null) removeProject(p);
		List<Resource> resources = getResources();
		for (Resource r : resources) {
			removeResource(r);
		}
		
	}
	
	public boolean removeResource(Resource res) {
		return removeTeacher(res);
	}
	
	public void addTeacher(ResourceBase teacher) {//resource
		teachers.add(teacher);
		teacher.addToCompanionship(this);
		//update the list of assigned skills to the project
		updateAssignedSkills();
	}
	
	public void updateAssignedSkills() {
		Project proj = getProject();
		if (proj != null) {
			assignedSkills.clear();
			for (ResourceBase tr : teachers) {
				if (tr instanceof Resource) {
					Resource res = (Resource)tr;
					for (Skill s : res.getSkillSet()) {
						Integer howManyOfThisSkillAreCurrentlyAssignedToThisProject = assignedSkills.get(s);
						if (howManyOfThisSkillAreCurrentlyAssignedToThisProject == null) {
							howManyOfThisSkillAreCurrentlyAssignedToThisProject = 0;
						}
						++howManyOfThisSkillAreCurrentlyAssignedToThisProject;
						assignedSkills.put(s,howManyOfThisSkillAreCurrentlyAssignedToThisProject);
					}
				}
			}
		}		
	}
	
	public List<ResourceBase> getAllTeachers() {
		return teachers;
	}
	
	public boolean removeTeacher(ResourceBase teacher) {
		teachers.remove(teacher);
		teacher.removeFromCompanionship(this);
		updateAssignedSkills();
		return true;
	}
	
	public void addTeachee(ProjectBase teachee) {//project
		teachees.add(teachee);
		teachee.setTeachers(this);
		updateAssignedSkills();
	}
	
	public void removeTeachee(ProjectBase teachee) {//project
		teachees.remove(teachee);
		teachee.removeTeachers();
		updateAssignedSkills();
	}
	
	public List<ProjectBase> getAllTeachees() {
		return teachees;
	}
	
	public boolean contains(Entity o) {
		return (teachers.contains(o) || teachees.contains(o));
	}
	
	public int howManyOfThisSkillAreCurrentlyAssignedToThisProject(Skill s) {
		int result = 0;
		Integer candidateResult = assignedSkills.get(s);
		if (candidateResult != null) {
			result = candidateResult;
		}
		return result;
	}
	
	@Override
	public String toString() {
		StringBuilder buff = new StringBuilder();
		for (ProjectBase t : teachees) {
			buff.append(t.getName());
			buff.append(" ");
		}
		buff.append(": ");
		for (ResourceBase t : teachers) {
			buff.append(t.getName());
			buff.append(" ");
		}
		return new String(buff);
	}

	public int compareTo(Team o) {
		Project proj1 = getProject();
		Project proj2 = o.getProject();
		if (proj1 == null || proj2 == null) return 0;
		return proj1.getName().compareTo(proj2.getName());
	}
}
