package projman;


import java.awt.Dimension;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import projman.Ward.WardListener;

public class WhiteboardTab extends JSplitPane
		implements WardListener {
	
	private WhiteboardWidget mainPanel;
	private JSplitPane leftPanel;
	private CandidateList resourceList;
	private CandidateList projectList;
	private Ward ward;
	private Auxiliary currentAuxiliary;
	private static final long serialVersionUID = 42L;
	
	//TODO make it so that when you click in one of the candidate lists,
	//the current "selection lasso" (if any) in the whiteboardwidget goes away.
	
	public WhiteboardTab(Ward ward, Auxiliary aux) {
		super(JSplitPane.HORIZONTAL_SPLIT, true);
		this.ward = ward;
		this.ward.addWardListener(this);
		this.currentAuxiliary = aux;
		EntityTransferHandler transferHandler = new EntityTransferHandler();
		mainPanel = new WhiteboardWidget(ward);
		resourceList = new CandidateList(ward, currentAuxiliary, EntityStatus.PROJECT);
		projectList = new CandidateList(ward, currentAuxiliary, EntityStatus.RESOURCE);
		leftPanel = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true);
		leftPanel.setTopComponent(resourceList);
		leftPanel.setBottomComponent(projectList);
		leftPanel.setMinimumSize(new Dimension(0, 0));
		
		//JScrollPane scroller = new JScrollPane(mainPanel, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		//scroller.setPreferredSize(new Dimension(200,200));
		mainPanel.setTransferHandler(transferHandler);
		resourceList.setCustomTransferHandler(transferHandler);
		projectList.setCustomTransferHandler(transferHandler);
		setLeftComponent(leftPanel);
		setRightComponent(mainPanel);
		//setRightComponent(scroller);
	}

	public Auxiliary getCurrentAuxiliary() {
		return currentAuxiliary;
	}

	public void setCurrentAuxiliary(Auxiliary currentAuxiliary) {
		this.currentAuxiliary = currentAuxiliary;
		mainPanel.setCurrentAuxiliary(currentAuxiliary);
		refreshLists();
	}

	public void wardChanged() {
		refreshLists();
		mainPanel.refreshCards();
	}
	
	private void refreshLists() {
		resourceList.refresh(this.currentAuxiliary);
		projectList.refresh(this.currentAuxiliary);		
	}
	
	public void saveState(ObjectOutputStream s) throws Exception {
		mainPanel.saveState(s);
	}
	
	public void restoreState(ObjectInputStream s) throws Exception {
		mainPanel.restoreState(s);
	}
	
	//to be called only for testing!!
	public void arrangeTeamsNicely() {
		mainPanel.setTestMode();
	}
		
}
